/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.xml.XmlWriter;

public class ProjectPreferencesXMLGenerator
implements ProjectObjectSerializer {
    private static final String EXCEPTION_HANDLING_POLICY = "exceptionHandlingPolicy";
    private static final String ISTEMPLATE = "IsTemplate";
    private static final String SHARING_PREDEFINED_VARIABLES_DEFAULT = "sharingPredefinedVariablesDefault";
    private static final String J2EEMODE = "J2EEMode";

    @Override
    public void write(Writer writer, ProjectObject object) throws ProjectException {
        ProjectPreferences projectPreferences = (ProjectPreferences)object;
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        try {
            List<Object> it;
            xmlWriter.startDocument();
            xmlWriter.startElement("preferences");
            xmlWriter.startElement("general");
            xmlWriter.printAttribute(J2EEMODE, projectPreferences.isJ2EEMode());
            xmlWriter.printAttribute(ISTEMPLATE, projectPreferences.isTemplate());
            xmlWriter.endElement();
            xmlWriter.startElement("processes");
            if (projectPreferences.getExceptionHandlingType() != null) {
                xmlWriter.printAttribute(EXCEPTION_HANDLING_POLICY, projectPreferences.getExceptionHandlingType());
            }
            xmlWriter.printAttribute(SHARING_PREDEFINED_VARIABLES_DEFAULT, projectPreferences.getAllowsNotToShareInstanceVars());
            xmlWriter.printAttribute("generatesInteractiveRole", projectPreferences.getGeneratesInteractiveRole());
            xmlWriter.printAttribute("interactiveRole", projectPreferences.getInteractiveRole());
            xmlWriter.endElement();
            if (projectPreferences.getDefaultLanguage() != null) {
                xmlWriter.startElement("languages");
                xmlWriter.printAttribute("default", projectPreferences.getDefaultLanguage().toString());
                if (projectPreferences.getAvailableLanguages().size() > 0) {
                    it = projectPreferences.getAvailableLanguages();
                    String languages = "";
                    for (Locale locale : it) {
                        languages = languages + locale.toString() + ";";
                    }
                    languages = languages.substring(0, languages.lastIndexOf(";"));
                    xmlWriter.printAttribute("availables", languages);
                }
                xmlWriter.endElement();
            }
            if (projectPreferences.getDependencies().size() > 0) {
                xmlWriter.startElement("dependencies");
                it = projectPreferences.getDependencies();
                String projects = "";
                for (String string : it) {
                    projects = projects + string + ";";
                }
                projects = projects.substring(0, projects.lastIndexOf(";"));
                xmlWriter.printAttribute("projects", projects);
                xmlWriter.endElement();
            }
            if (projectPreferences.isAllowReadWriteOptionalTasks()) {
                xmlWriter.startElement("activity");
                xmlWriter.printAttribute("allowReadWriteOptionalTasks", projectPreferences.isAllowReadWriteOptionalTasks());
                xmlWriter.endElement();
            }
            xmlWriter.startElement("generateEvents");
            xmlWriter.printAttribute("type", projectPreferences.getKeyPerformanceIndicatorsContainer().getGenerateEvents());
            xmlWriter.endElement();
            if (!Str.isEmpty(projectPreferences.getTemplateName()) || projectPreferences.isTemplate()) {
                xmlWriter.startElement("templateName");
                String templateName = Str.isEmpty(projectPreferences.getTemplateName()) ? projectPreferences.getProject().getName() : projectPreferences.getTemplateName();
                xmlWriter.printAttribute("name", templateName);
                xmlWriter.endElement();
            }
            if (!Str.isEmpty(projectPreferences.getTemplateViewIdentifier())) {
                xmlWriter.startElement("templateViewIdentifier");
                xmlWriter.printAttribute("name", projectPreferences.getTemplateViewIdentifier());
                xmlWriter.endElement();
            }
            if (!projectPreferences.getDatabaseGrantees().isEmpty()) {
                xmlWriter.startElement("databaseGrantees");
                for (String grantee : projectPreferences.getDatabaseGrantees()) {
                    xmlWriter.startElement("grantee");
                    xmlWriter.printAttribute("name", grantee);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        catch (IOException ioe) {
            try {
                throw ProjectException.wrap(projectPreferences, Msg.QUOTE(ioe.getMessage()), ioe);
            }
            catch (Throwable throwable) {
                StreamUtils.close(xmlWriter);
                throw throwable;
            }
        }
        StreamUtils.close(xmlWriter);
    }
}

