/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;

public class ProcessMeasurementsListenersManager {
    private ProjectListenerAdapter<Activity> activityEventsListener;
    private ProjectListenerAdapter<Counter> counterListener;
    private ProjectListenerAdapter<Measurement> measurementMarkListener;
    private ProjectListenerAdapter<Process> processGenerateEventsListener;
    private static ProcessMeasurementsListenersManager instance;

    private ProcessMeasurementsListenersManager() {
    }

    public static synchronized ProcessMeasurementsListenersManager getInstance() {
        if (instance == null) {
            instance = new ProcessMeasurementsListenersManager();
        }
        return instance;
    }

    public void startListeningProcessMeasurementsChanges(Process process) {
        process.addListener(this.getMeasurementsFileGeneratorListener());
        process.addListener(this.getCountersFileGeneratorListener());
        process.addListener(this.getProcessGenerateEventsListener());
        process.addListener(this.getActivityGenerateEventsListener());
    }

    private ProjectListener<Activity> getActivityGenerateEventsListener() {
        if (this.activityEventsListener == null) {
            this.activityEventsListener = new ProjectListenerAdapter<Activity>(Activity.class){

                @Override
                public void postObjectAdded(Activity activity, ProjectObject parent) {
                    activity.getProcess().setMeasurementsChanged(true);
                }

                @Override
                public void objectChanged(Activity activity, ProjectEvent event) {
                    if ("generatesEvents".equals(event.getPropertyName())) {
                        activity.getProcess().setMeasurementsChanged(true);
                    }
                }

                @Override
                public void postObjectRemoved(Activity activity, ProjectObject parent) {
                    activity.getProcess().setMeasurementsChanged(true);
                }
            };
        }
        return this.activityEventsListener;
    }

    private ProjectListener<Process> getProcessGenerateEventsListener() {
        if (this.processGenerateEventsListener == null) {
            this.processGenerateEventsListener = new ProjectListenerAdapter<Process>(Process.class){

                @Override
                public void objectChanged(Process process, ProjectEvent event) {
                    if ("generatesEvents".equals(event.getPropertyName())) {
                        process.setMeasurementsChanged(true);
                    }
                }

                @Override
                public void postObjectAdded(Process object, ProjectObject parent) {
                    super.postObjectAdded(object, parent);
                }
            };
        }
        return this.processGenerateEventsListener;
    }

    private ProjectListener<Measurement> getMeasurementsFileGeneratorListener() {
        if (this.measurementMarkListener == null) {
            this.measurementMarkListener = new ProjectListenerAdapter<Measurement>(Measurement.class){

                @Override
                public void postObjectAdded(Measurement measurement, ProjectObject parent) {
                    measurement.getParentObject().setMeasurementsChanged(true);
                }

                @Override
                public void objectChanged(Measurement measurement, ProjectEvent event) {
                    measurement.getParentObject().setMeasurementsChanged(true);
                }

                @Override
                public void postObjectRemoved(Measurement measurement, ProjectObject parent) {
                    measurement.getParentObject().setMeasurementsChanged(true);
                }
            };
        }
        return this.measurementMarkListener;
    }

    private ProjectListener<Counter> getCountersFileGeneratorListener() {
        if (this.counterListener == null) {
            this.counterListener = new ProjectListenerAdapter<Counter>(Counter.class){

                @Override
                public void postObjectAdded(Counter counter, ProjectObject parent) {
                    counter.getActivity().getProcess().setMeasurementsChanged(true);
                }

                @Override
                public void objectChanged(Counter counter, ProjectEvent event) {
                    counter.getActivity().getProcess().setMeasurementsChanged(true);
                }

                @Override
                public void postObjectRemoved(Counter counter, ProjectObject parent) {
                    counter.getActivity().getProcess().setMeasurementsChanged(true);
                }
            };
        }
        return this.counterListener;
    }
}

