/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpm.analytics.measurement.metadata.model.Actions;
import oracle.bpm.analytics.measurement.metadata.model.Measurements;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.sensor.MeasurementActionsBuilder;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;

public class MeasurementActionsFileGenerator {
    private VFile measurementActionsFile;
    private Project project;
    private static JAXBContext jaxbContext = null;
    private static final String file = "measurementActions.xml";

    public MeasurementActionsFileGenerator(@NotNull Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateFile(@NotNull Measurements measurements) {
        OutputStreamWriter writer = null;
        VFileOutputStream outputStream = null;
        this.measurementActionsFile = this.getMeasurementActionsFile();
        try {
            outputStream = new VFileOutputStream(this.measurementActionsFile);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)this.getRootJaxbElement(this.project, measurements), (Writer)writer);
        }
        catch (IOException e) {
            Log.logSevere(e);
            StreamUtils.close(new Closeable[]{outputStream});
            StreamUtils.close(writer);
        }
        catch (JAXBException e2) {
            Log.logSevere(e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.close(new Closeable[]{outputStream});
                    StreamUtils.close(writer);
                    throw throwable;
                }
            }
            StreamUtils.close(new Closeable[]{outputStream});
            StreamUtils.close(writer);
        }
        StreamUtils.close(new Closeable[]{outputStream});
        StreamUtils.close(writer);
    }

    public VFile getMeasurementActionsFile() {
        if (this.measurementActionsFile == null) {
            this.measurementActionsFile = this.createFile();
        }
        return this.measurementActionsFile;
    }

    private Actions getRootJaxbElement(Project project, Measurements measurements) {
        MeasurementActionsBuilder measurementActionsBuilder = new MeasurementActionsBuilder(project, measurements);
        return measurementActionsBuilder.build();
    }

    private VFile createFile() {
        VFileSystem dataFileSystem = this.project.getWriter().getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(dataFileSystem.getRoot(), file);
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        return jaxbContext;
    }
}

