/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementStates;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementTypes;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TElementState;
import oracle.bpm.analytics.measurement.metadata.model.TElementType;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElementType;
import oracle.bpm.project.io.sensor.TMeasurementElementBuilder;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;

public class BuilderFromMeasurementMarks
extends TMeasurementElementBuilder<Process> {
    public BuilderFromMeasurementMarks(Process process, ObjectFactory objectFactory, Map<TElementState, String> storedElements) {
        super(process, objectFactory, storedElements);
    }

    @Override
    public Collection<TMeasurementElement> build() {
        ArrayList<TMeasurementElement> tMeasurementElements = new ArrayList<TMeasurementElement>();
        for (Measurement measurement : ((Process)this.getElement()).getDescendants(Measurement.class)) {
            TElementState state = TElementState.fromValue((String)measurement.getMeasurementType().getValue());
            if (this.getStoredElements().containsKey(state)) continue;
            TMeasurementElement tMeasurementElement = this.getObjectFactory().createTMeasurementElement();
            tMeasurementElement.setEnabled(true);
            tMeasurementElement.setType(TMeasurementElementType.COMPOSITE);
            String id = measurement.getId();
            tMeasurementElement.setName(id);
            tMeasurementElement.setUserDefined(true);
            ListOfElementTypes elementTypes = this.getObjectFactory().createListOfElementTypes();
            elementTypes.getElementType().add(TElementType.ALL);
            tMeasurementElement.setElementTypes(elementTypes);
            ListOfElementStates elementStates = this.getObjectFactory().createListOfElementStates();
            elementStates.getElementState().add(state);
            tMeasurementElement.setElementStates(elementStates);
            tMeasurementElements.add(tMeasurementElement);
            this.getStoredElements().put(state, id);
        }
        return tMeasurementElements;
    }
}

