/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementStates;
import oracle.bpm.analytics.measurement.metadata.model.ListOfElementTypes;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TElementState;
import oracle.bpm.analytics.measurement.metadata.model.TElementType;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElementType;
import oracle.bpm.project.io.sensor.TMeasurementElementBuilder;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Process;

public class BuilderFromCounters
extends TMeasurementElementBuilder<Process> {
    public BuilderFromCounters(Process process, ObjectFactory objectFactory, Map<TElementState, String> storedElements) {
        super(process, objectFactory, storedElements);
    }

    @Override
    public Collection<TMeasurementElement> build() {
        ArrayList<TMeasurementElement> tMeasurementElements = new ArrayList<TMeasurementElement>();
        for (Counter counter : ((Process)this.getElement()).getChildrenByType(Counter.class)) {
            TElementState state = TElementState.MEASUREMENT_COUNTER;
            if (this.getStoredElements().containsKey(state)) continue;
            TMeasurementElement tMeasurementElement = this.getObjectFactory().createTMeasurementElement();
            tMeasurementElement.setEnabled(true);
            tMeasurementElement.setType(TMeasurementElementType.COMPOSITE);
            tMeasurementElement.setUserDefined(true);
            String id = counter.getId();
            tMeasurementElement.setName(id);
            ListOfElementTypes elementTypes = this.getObjectFactory().createListOfElementTypes();
            elementTypes.getElementType().add(TElementType.ALL);
            tMeasurementElement.setElementTypes(elementTypes);
            ListOfElementStates elementStates = this.getObjectFactory().createListOfElementStates();
            elementStates.getElementState().add(state);
            tMeasurementElement.setElementStates(elementStates);
            tMeasurementElements.add(tMeasurementElement);
            this.getStoredElements().put(state, id);
        }
        return tMeasurementElements;
    }
}

