/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.io.IOException;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.bpm.project.model.ProjectObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Recognizer {
    public Class<? extends ProjectObject> recognize(@NotNull InputSource var1) throws IOException;

    public static abstract class Default
    implements Recognizer {
        @Override
        public abstract Class<? extends ProjectObject> recognize(InputSource var1) throws IOException;

        @NotNull
        protected final String sanitizeExtension(@NotNull String extension) {
            if (extension.charAt(0) != '.') {
                extension = ".".concat(extension);
            }
            return extension;
        }

        @Nullable
        protected String getExtension(@Nullable InputSource inputSource) {
            String fileName = inputSource.getFileName();
            if (Str.isEmpty(fileName)) {
                return null;
            }
            int lastDot = fileName.lastIndexOf(46);
            int lastSlash = fileName.lastIndexOf(47);
            return lastDot >= 0 && lastDot > lastSlash ? fileName.substring(lastDot) : null;
        }

        protected final boolean equals(String extensionA, String extensionB) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.sanitizeExtension(extensionA), this.sanitizeExtension(extensionB)) == 0;
        }
    }
}

