/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.io.IOException;
import oracle.bpm.project.io.recognizer.BpmObjectRecognizer;
import oracle.bpm.project.io.recognizer.ComponentRecognizer;
import oracle.bpm.project.io.recognizer.FileExtensionRecognizer;
import oracle.bpm.project.io.recognizer.FileNameRecognizer;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.bpm.project.io.recognizer.Recognizer;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.NotRecognizableObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.UnknownProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import org.jetbrains.annotations.NotNull;

public class ProjectRecognizer
extends Recognizer.Default {
    private final BpmObjectRecognizer bpmRecognizer;
    private final ComponentRecognizer componentRecognizer;
    private final FileExtensionRecognizer fileExtensionRecognizer;
    private final FileNameRecognizer fileNameRecognizer = new FileNameRecognizer();
    private static ProjectRecognizer instance;

    private ProjectRecognizer() {
        this.fileExtensionRecognizer = new FileExtensionRecognizer();
        this.componentRecognizer = new ComponentRecognizer();
        this.bpmRecognizer = new BpmObjectRecognizer();
    }

    public static ProjectRecognizer getInstance() {
        if (instance == null) {
            instance = new ProjectRecognizer();
        }
        return instance;
    }

    @Override
    public Class<? extends ProjectObject> recognize(@NotNull InputSource inputSource) {
        Class<? extends ProjectObject> result = this.fileNameRecognizer.recognize(inputSource);
        if (result == null && ((result = this.fileExtensionRecognizer.recognize(inputSource)) == null || result == CatalogObject.class) && (result = this.bpmRecognizer.recognize(inputSource)) == null) {
            result = this.componentRecognizer.recognize(inputSource);
        }
        try {
            if (result == null && inputSource.isFolder()) {
                result = FolderContainer.class;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null && result.equals(NotRecognizableObject.class)) {
            return null;
        }
        if (result == null) {
            result = UnknownProjectObject.class;
        }
        assert (result.isInterface()) : "Recognized class must be an Interface";
        return result;
    }

    public String[] getRecognizedExtensions() {
        return this.fileExtensionRecognizer.getRecognizedExtensions();
    }
}

