/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.bpm.project.io.recognizer.Recognizer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.type.TypeInfo;

public class ComponentRecognizer
extends Recognizer.Default {
    private final TypeInfo.Parser parser = new TypeInfo.Parser();

    ComponentRecognizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<? extends ProjectObject> recognize(InputSource inputSource) {
        Class<? extends ProjectObject> result = null;
        try {
            String extension = this.getExtension(inputSource);
            if (!Str.isEmpty(extension) && !this.equals(extension, ".xcdl")) {
                return result;
            }
            InputStream byteStream = inputSource.open();
            try {
                if (byteStream == null) {
                    Class<? extends ProjectObject> clazz = result;
                    return clazz;
                }
                TypeInfo typeInfo = this.parser.parse((Reader)new InputStreamReader(byteStream));
                result = this.getProjectObjectClassForTypeInfo(typeInfo);
                return result;
            }
            finally {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Class<? extends ProjectObject> getProjectObjectClassForTypeInfo(TypeInfo typeInfo) {
        Class<? extends ProjectObject> result = null;
        return result;
    }
}

