/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.mem;

import java.io.File;
import java.util.List;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;

public class MemoryProjectLoader
implements ProjectLoader {
    private Project project;
    private ProjectRepository repository;
    private static MutableComponentCatalog defaultCatalog_sd;

    public MemoryProjectLoader(Project project, ProjectRepository repository) {
        this.project = project;
        this.repository = repository;
    }

    public static MutableComponentCatalog getDefaultCatalog(ProgressMonitor m) {
        if (defaultCatalog_sd == null) {
            defaultCatalog_sd = TypeUtils.getDefaultCatalog((ProgressMonitor)m);
        }
        return defaultCatalog_sd;
    }

    @Override
    public ProjectRepository getProjectRepository() {
        return this.repository;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public <T extends ProjectObject> T createFromXml(Class<T> objectClass, String xml) {
        return null;
    }

    public void loadProcesses(ProgressMonitor monitor) {
    }

    public void loadEngine(ProgressMonitor monitor) {
    }

    @Override
    public void loadCatalog(ProgressMonitor monitor) throws ProjectException {
        MutableComponentCatalog defaultCatalog = MemoryProjectLoader.getDefaultCatalog(null);
        Project project = this.getProject();
        MutableComponentCatalog projectRepository = TypeUtils.createComponentCatalog((MutableComponentCatalog)defaultCatalog);
        projectRepository.setOwner((Object)project);
        projectRepository.setDescription(project.getName());
        projectRepository.setWorkingInMemory(true);
        projectRepository.sync();
        projectRepository.getRoot();
        project.setComponentCatalog((ComponentCatalog)projectRepository);
    }

    public void loadModelSimulations(Process process, ProgressMonitor monitor) throws ProjectException {
    }

    @Override
    public Object loadSystemObject(String id) throws ProjectException {
        return null;
    }

    @Override
    public ProjectObject replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        return projectObject;
    }

    public ProjectObject loadProjectObject(ProjectObject projectObject) throws ProjectException {
        return null;
    }

    public void loadConfigurationManager() throws ProjectException {
    }

    @Override
    public void loadDashboards() throws ProjectException {
    }

    @Override
    public void dispose() {
    }

    public ProjectObject loadProjectObject(ProjectObjectType type, File f) throws ProjectException {
        return null;
    }

    public File getBaseDir() {
        return null;
    }

    public boolean isProjectObjectLoaded(ProjectObjectType projectObjectType) {
        return false;
    }

    @Override
    public <P extends ProjectObject> List<P> getAllObjects(@NotNull Class<P> objectClass) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <P extends ProjectObject> P getObject(@NotNull ResourceContainer container, @NotNull Class<P> objectClass, @NotNull String id) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectObject> getChildren(@NotNull ResourceContainer container) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <P extends ProjectObject> List<P> getChildrenByType(@NotNull ResourceContainer container, @NotNull Class<P> objectClass) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <P extends ProjectObject> P reloadObject(@NotNull P object) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<VFile> getAllFiles(@NotNull Class<? extends ProjectObject> objectClass) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFileSystem getProjectFileSystem() {
        return null;
    }
}

