/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.util.Collection;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.HumanTaskImpl;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.io.fs.writer.CatalogWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.soa.io.IOFactory;

@ProjectObjectWriterMetadata(objectClasses={HumanTask.class})
public class HumanTaskWriter
extends CatalogWriter {
    public static void removeCaseActivities(Project project, String taskName) throws ProjectException {
        if (project != null && project.getCase() != null) {
            ProjectCase projectCase = project.getCase();
            Collection<ProjectCaseActivity> caseActivities = projectCase.getCaseActivitiesForHumantask(taskName);
            for (ProjectCaseActivity caseActivity : caseActivities) {
                caseActivity.delete();
            }
        }
    }

    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        try {
            HumanTaskImpl humanTask = (HumanTaskImpl)projectObject;
            VFile taskFile = (VFile)humanTask.as(VFile.class);
            VFile root = taskFile.getFileSystem().getRoot();
            IOFactory.createTaskVFileIO().saveTask((Object)root, humanTask.getTask());
        }
        catch (Exception e) {
            throw ProjectException.wrap(projectObject, e);
        }
        return super.write(projectObject);
    }

    @Override
    public void delete(ProjectObject projectObject) throws ProjectException {
        try {
            HumanTaskImpl humanTask = (HumanTaskImpl)projectObject;
            VFile taskFile = (VFile)humanTask.as(VFile.class);
            if (taskFile != null) {
                oracle.bpm.soa.humantask.HumanTask task = humanTask.getTask();
                String taskName = task.getName();
                Project project = humanTask.getProject();
                HumanTaskWriter.removeCaseActivities(project, taskName);
                HumanTaskWriter.updateComposite(project, taskName);
                if (!CompositeAccessorFactory.isFusionPlatform()) {
                    VFile root = taskFile.getFileSystem().getRoot();
                    IOFactory.createTaskVFileIO().deleteTask((Object)root, task);
                }
                super.delete(projectObject);
            }
        }
        catch (Exception e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }

    private static void updateComposite(Project project, String humanTaskName) throws ProjectException {
        ScaController scaController = CompositeAccessorFactory.createScaController((Project)project);
        scaController.deleteComponent(humanTaskName);
        scaController.commitChanges();
    }
}

