/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.util.Collections;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.BusinessRuleImpl;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.io.fs.writer.CatalogWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.soa.rules.DecisionServiceUtil;
import oracle.bpm.soa.rules.DecisionServiceUtilFactory;
import oracle.bpm.soa.rules.io.RulesIO;
import oracle.rules.sdk2.dictionary.RuleDictionary;

@ProjectObjectWriterMetadata(objectClasses={BusinessRule.class})
public class BusinessRuleWriter
extends CatalogWriter {
    @Override
    public void delete(ProjectObject projectObject) throws ProjectException {
        try {
            BusinessRuleImpl businessRule = (BusinessRuleImpl)projectObject;
            VFile dictionaryFile = (VFile)businessRule.as(VFile.class);
            VFile projectRoot = dictionaryFile.getFileSystem().getRoot();
            RuleDictionary dictionary = businessRule.getDictionary();
            List decisionServices = Collections.emptyList();
            if (!CompositeAccessorFactory.isFusionPlatform()) {
                RulesIO rulesIO = IOFactory.createRulesVFileIO();
                rulesIO.deleteDictionary((Object)projectRoot, dictionary);
                DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)projectRoot, (String)projectObject.getProject().getName());
                decisionServices = dsUtil.deleteDecisionComponent(dictionary.getName());
            }
            BusinessRuleWriter.deleteFromComposite(businessRule.getProject(), dictionary.getName(), decisionServices);
            super.delete(projectObject);
        }
        catch (Exception e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }

    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        try {
            BusinessRuleImpl businessRule = (BusinessRuleImpl)projectObject;
            VFile dictionaryFile = (VFile)businessRule.as(VFile.class);
            VFile root = dictionaryFile.getFileSystem().getRoot();
            IOFactory.createRulesVFileIO().saveDictionary((Object)root, businessRule.getDictionary());
        }
        catch (Exception e) {
            throw ProjectException.wrap(projectObject, e);
        }
        return super.write(projectObject);
    }

    private static void deleteFromComposite(Project project, String ruleName, List<String> decisionServices) throws ProjectException {
        ScaController scaController = CompositeAccessorFactory.createScaController((Project)project);
        scaController.deleteComponent(ruleName);
        for (String decisionService : decisionServices) {
            scaController.deleteServiceEntrypoint(decisionService);
        }
        scaController.commitChanges();
    }
}

