/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.simulation.project.ProjectSimulationJaxbLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={ProjectSimulation.class})
public class ProjectSimulationLoader
extends ProjectObjectLoader<ProjectSimulation> {
    @Override
    public ProjectSimulation create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return this.project.getSimulations().createProjectSimulation("");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectSimulation loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        VFileInputStream fileInputStream = null;
        ProjectSimulation simulation = null;
        try {
            fileInputStream = new VFileInputStream(file);
            simulation = this.loadObject((InputStream)fileInputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{fileInputStream});
        return simulation;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectSimulation loadObject(@NotNull InputStream in) throws ProjectException {
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        ProjectSimulation simulation = null;
        try {
            inputStreamReader = new InputStreamReader(in, Literals.DEFAULT_ENCODING);
            reader = new BufferedReader(inputStreamReader);
            ProjectSimulationJaxbLoader projectSimulationJaxbLoader = ProjectSimulationJaxbLoader.create(reader, this.getProject());
            simulation = projectSimulationJaxbLoader.load();
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
                catch (ParserException e3) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(reader);
                StreamUtils.close(inputStreamReader);
                throw throwable;
            }
        }
        StreamUtils.close(reader);
        StreamUtils.close(inputStreamReader);
        return simulation;
    }
}

