/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.persistence.CaseActivityPersistenceManager;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.project.casemgmt.ProjectCaseActivityImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={ProjectCaseActivity.class})
public class ProjectCaseActivityLoader
extends ProjectObjectLoader<ProjectCaseActivity> {
    @Override
    public ProjectCaseActivity create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        CaseActivity caseActivity = null;
        VFileInputStream is = null;
        try {
            is = new VFileInputStream(file);
            caseActivity = (CaseActivity)CaseActivityPersistenceManager.INSTANCE.load((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap((ProjectObject)container, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{is});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{is});
        return new ProjectCaseActivityImpl(caseActivity);
    }

    @Override
    public ProjectCaseActivity loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return this.create(container, file);
    }
}

