/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.simulation.model.ModelSimulationJaxbLoader;
import oracle.bpm.project.model.ModelSimulationProcess;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={ModelSimulation.class})
public class ModelSimulationsLoader
extends ProjectObjectLoader<ModelSimulation> {
    @Override
    public ModelSimulation create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return container.createEmptyModelSimulation(this.getModelIdFrom(container), "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelSimulation loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ModelSimulation modelSimulation;
        VFileInputStream fileInputStream;
        InputStreamReader inputStreamReader;
        BufferedReader reader;
        block8: {
            ModelSimulation projectSimulationJaxbLoader2222222;
            String modelId = this.getModelIdFrom(container);
            reader = null;
            inputStreamReader = null;
            fileInputStream = null;
            modelSimulation = null;
            try {
                fileInputStream = new VFileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Literals.DEFAULT_ENCODING);
                reader = new BufferedReader(inputStreamReader);
                if (modelId != null) {
                    ModelSimulationJaxbLoader projectSimulationJaxbLoader2222222 = ModelSimulationJaxbLoader.create(reader, container);
                    modelSimulation = projectSimulationJaxbLoader2222222.load();
                    break block8;
                }
                Log.logSevere(ProjectMsg.MODEL_NOT_FOUND_FOR_SIMULATION((String)file.getName()));
                projectSimulationJaxbLoader2222222 = null;
            }
            catch (FileNotFoundException e) {
                try {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                    catch (UnsupportedEncodingException e2) {
                        throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                    }
                    catch (IOException e3) {
                        throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                    }
                    catch (ParserException e4) {
                        throw ProjectException.wrap((ProjectObject)this.getProject(), e4);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.close(reader);
                    StreamUtils.close(inputStreamReader);
                    StreamUtils.close(new Closeable[]{fileInputStream});
                    throw throwable;
                }
            }
            StreamUtils.close(reader);
            StreamUtils.close(inputStreamReader);
            StreamUtils.close(new Closeable[]{fileInputStream});
            return projectSimulationJaxbLoader2222222;
        }
        StreamUtils.close(reader);
        StreamUtils.close(inputStreamReader);
        StreamUtils.close(new Closeable[]{fileInputStream});
        return modelSimulation;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelSimulation loadObject(@NotNull InputStream in) throws ProjectException {
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        ModelSimulation modelSimulation = null;
        try {
            inputStreamReader = new InputStreamReader(in, Literals.DEFAULT_ENCODING);
            reader = new BufferedReader(inputStreamReader);
            ModelSimulationJaxbLoader projectSimulationJaxbLoader = ModelSimulationJaxbLoader.create(reader, this.getProject().getSimulations().getModelSimulationsContainer());
            modelSimulation = projectSimulationJaxbLoader.load();
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                }
                catch (ParserException e3) {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(reader);
                StreamUtils.close(inputStreamReader);
                throw throwable;
            }
        }
        StreamUtils.close(reader);
        StreamUtils.close(inputStreamReader);
        return modelSimulation;
    }

    private String getModelIdFrom(ResourceContainer container) {
        if (container instanceof ModelSimulationProcess) {
            return container.getId();
        }
        return null;
    }
}

