/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.InputStream;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.project.activityguide.ActivityGuideImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.activityguide.ActivityGuidePersistenceManager;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={ActivityGuide.class})
public class ActivityGuideLoader
extends ProjectObjectLoader<ActivityGuide> {
    @Override
    public ActivityGuide create(@NotNull ResourceContainer container, @NotNull VFile file) {
        return new ActivityGuideImpl(this.getProject(), VFileUtils.getName((VFile)file));
    }

    @Override
    public ActivityGuide loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ActivityGuide activityGuide;
        ActivityGuide activityGuide2 = this.create(container, file);
        VFileInputStream is = null;
        try {
            is = new VFileInputStream(file);
            activityGuide = ActivityGuidePersistenceManager.getInstance().parse((InputStream)is, activityGuide2);
        }
        catch (Throwable e) {
            try {
                throw ProjectException.wrap((ProjectObject)activityGuide2, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{is});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{is});
        return activityGuide;
    }

    @Override
    public ActivityGuide loadObject(@NotNull InputStream in) throws ProjectException {
        ActivityGuideImpl activityGuide = new ActivityGuideImpl(this.getProject(), "");
        return ActivityGuidePersistenceManager.getInstance().parse(in, (ActivityGuide)activityGuide);
    }
}

