/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractSimulationChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.util.FileUtils;

public class ProjectSimulationChangeManager
extends AbstractSimulationChangeManager {
    private ProjectSimulationChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ProjectSimulationChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ProjectSimulationChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xpsi".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().getSimulations().addProjectSimulation((ProjectSimulation)projectObject);
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getProject().getSimulations().findProjectSimulation(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT_SIMULATION;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

