/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractProcessChangeManager;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileUtils;

public class ModelChangeManager
extends AbstractProcessChangeManager {
    protected ModelChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ModelChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ModelChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && (this.isProcess(resourceFile) || this.isProcedure(resourceFile) || this.isScreenflow(resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        FolderContainer modelContainer = (FolderContainer)projectObject.getParentObject();
        modelContainer.addChild(projectObject);
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return null;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        Process newProcess = (Process)projectObject;
        this.getProject().replace((ProjectObject)newProcess);
        return false;
    }

    private boolean isProcess(File resourceFile) {
        String iResourceExtension = FileUtils.getExtension((File)resourceFile);
        return (".xpdl".equals(iResourceExtension) || ".bpel".equals(iResourceExtension)) && !"default".equals(FileUtils.getName((File)resourceFile));
    }

    private boolean isProcedure(File resourceFile) {
        String iResourceExtension = FileUtils.getExtension((File)resourceFile);
        return ".xadl".equals(iResourceExtension);
    }

    private boolean isScreenflow(File resourceFile) {
        String iResourceExtension = FileUtils.getExtension((File)resourceFile);
        return ".xsdl".equals(iResourceExtension);
    }
}

