/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.datacontrol;

import java.util.Arrays;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MetadataAdapter {
    private final Element node;
    static final String DC_DEF_ELEMENT = "bpmObjectDataControl";
    private static final int CURRENT_VERSION = 1;
    private static final Predicate<Node> IS_METADATA_NODE = new Predicate<Node>(){

        @Override
        public boolean check(@Nullable Node value) {
            return value != null && MetadataAdapter.DC_DEF_ELEMENT.equals(value.getNodeName());
        }
    };

    private MetadataAdapter(Element node) {
        this.node = node;
    }

    public int getVersion() {
        return Integer.parseInt(this.node.getAttribute("version"));
    }

    public Element getNode() {
        return this.node;
    }

    public String getName() {
        return CollectionUtils.last(Arrays.asList(this.getPath().split("/")));
    }

    public void setPath(String process) {
        this.node.setAttribute("path", process);
    }

    public String getPath() {
        return this.node.getAttribute("path");
    }

    public void setProject(String project) {
        this.node.setAttribute("project", project);
    }

    public String getProject() {
        return this.node.getAttribute("project");
    }

    public String toString() {
        return "MetadataAdapter{version=" + this.getVersion() + ", path='" + this.getPath() + '\'' + ", project='" + this.getProject() + '\'' + '}';
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static MetadataAdapter createNew() {
        XMLDocument xDoc = new XMLDocument();
        Element metadata = xDoc.createElementNS("http://xmlns.oracle.com/bpm/bpmobject/", DC_DEF_ELEMENT);
        MetadataAdapter metadataAdapter = new MetadataAdapter(metadata);
        metadataAdapter.setVersion(1);
        MetadataAdapter metadataAdapter2 = metadataAdapter;
        if (metadataAdapter2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/datacontrol/MetadataAdapter.createNew must not return null");
        }
        return metadataAdapter2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static MetadataAdapter loadFrom(Node node) {
        Element metadataNode = CollectionUtils.first(CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(node.getChildNodes()).select(IS_METADATA_NODE), Element.class));
        if (metadataNode == null) {
            throw new IllegalArgumentException("Unable to finde a bpmObjectDataControl node.");
        }
        MetadataAdapter metadataAdapter = new MetadataAdapter(metadataNode);
        if (metadataAdapter == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/datacontrol/MetadataAdapter.loadFrom must not return null");
        }
        return metadataAdapter;
    }

    private void setVersion(int version) {
        this.node.setAttribute("version", String.valueOf(version));
    }
}

