/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.datacontrol;

import java.io.Serializable;
import java.util.Map;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.binding.DataControl;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.bpm.bpmobject.datacontrol.BpmObjectDataControl;
import oracle.bpm.bpmobject.datacontrol.DataControlHelper;
import oracle.bpm.bpmobject.datacontrol.MetadataAdapter;
import oracle.bpm.bpmobject.datacontrol.type.StructureDefinitionAdapter;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.UnknownType;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpmObjectDefinition
extends AbstractDefinition
implements Serializable {
    @NotNull
    private MetadataAdapter metadata;
    private static final long serialVersionUID = 0L;

    public BpmObjectDefinition() {
    }

    public BpmObjectDefinition(@NotNull DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/datacontrol/BpmObjectDefinition.<init> must not be null");
        }
        this.metadata = MetadataAdapter.createNew();
        this.metadata.setPath(dataObject.getPath().toString());
        this.metadata.setProject(dataObject.getProject().getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Node getMetadata() {
        System.out.println("BpmObjectDefintion.getMetadata");
        Element element = this.metadata.getNode();
        if (element == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/datacontrol/BpmObjectDefinition.getMetadata must not return null");
        }
        return element;
    }

    public void loadFromMetadata(Node node, Map parameters) {
        System.out.println("BpmObjectDefintion.loadFromMetadata(" + node + ", " + parameters + ")");
        this.metadata = MetadataAdapter.loadFrom(node);
        System.out.println("metadata = " + this.metadata);
    }

    public StructureDefinition getStructure() {
        DataObject dataObject;
        Project project = DataControlHelper.findProject(this.metadata.getProject());
        TypeDescription type = project == null ? UnknownType.create(this.metadata.getName(), (ComponentCatalog)TypeUtils.getDefaultCatalog(), "Cannot find project: " + this.metadata.getProject()) : ((dataObject = this.findDataObject(project)) == null ? UnknownType.create(this.metadata.getName(), (ComponentCatalog)TypeUtils.getDefaultCatalog(), "Cannot find dataObject: " + this.metadata.getPath()) : dataObject.getType().getDelegate());
        StructureDef structureDef = new StructureDef(this.getName());
        if (type.isObject()) {
            StructureDefinitionAdapter structure = new StructureDefinitionAdapter((DataControlDefinition)this, (NamedDefinition)this, type.asObject());
            structureDef.addAccessor((AccessorDefinition)new AccessorDef(this.metadata.getName(), (StructureDefinition)structureDef, (StructureDefinition)structure, false));
        } else {
            structureDef.addAttribute((AttributeDefinition)new AttributeDef(this.metadata.getName(), (StructureDefinition)structureDef, type.getJavaType()));
        }
        return structureDef;
    }

    public DataControl createDataControl() {
        System.out.println("BpmObjectDefintion.createDataControl");
        return new BpmObjectDataControl();
    }

    public int getCachingMode() {
        return 2;
    }

    protected String getDCName() {
        return this.metadata.getName();
    }

    private DataObject findDataObject(Project project) {
        Process container;
        String[] path = this.metadata.getPath().split("/");
        if (path.length > 2 && "processes".equals(path[0]) && (container = project.findProcess(path[1])) != null) {
            for (int i = 2; i < path.length - 1; ++i) {
                String part = path[i];
                Activity activity = container.findActivity(part);
                if (activity == null) {
                    return null;
                }
                container = (NodeContainer)activity.asActivity(Subprocess.class);
                if (container != null) continue;
                return null;
            }
            return (DataObject)container.findDeclaration(DataObject.class, path[path.length - 1]);
        }
        return null;
    }
}

