/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.fusion.sca.Utils;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.catalog.composite.ScaBindingInfo;
import oracle.bpm.project.catalog.composite.ScaBindingInfoJca;
import oracle.bpm.project.catalog.composite.ScaBindingInfoWSIF;
import oracle.bpm.project.catalog.composite.ScaBindingInfoWs;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.ScaControllerContext;
import oracle.bpm.project.catalog.composite.ScaEventInfo;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.model.processes.Process;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.utils.NamespaceConflictException;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.BindingInfo;
import oracle.tip.tools.ide.fabric.api.BindingInfoDirect;
import oracle.tip.tools.ide.fabric.api.BindingInfoJCA;
import oracle.tip.tools.ide.fabric.api.BindingInfoWS;
import oracle.tip.tools.ide.fabric.api.BindingInfoWSIF;
import oracle.tip.tools.ide.fabric.api.EventInfo;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerContext;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.SCAControllerInterfaceImpl;
import oracle.tip.tools.ide.fabric.api.SCAInvalidFileNameException;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JdevScaController
implements ScaController {
    private final SCAController controller;
    private final Set<String> dirtyComponents = new HashSet<String>();
    private final Project jDevProject;
    private final oracle.bpm.project.model.Project project;
    private final SCAProject scaProject;

    public JdevScaController(oracle.bpm.project.model.Project project) {
        this.project = project;
        this.jDevProject = this.getJDevProject();
        this.scaProject = SCAProject.getSCAProject((Project)this.jDevProject);
        this.controller = SCAControllerImpl.getController((Project)this.jDevProject);
    }

    public boolean isNameUniqueWithinComposite(String componentName) {
        try {
            return this.controller.isNameUniqueWithinComposite(componentName);
        }
        catch (SCAInvalidFileNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void invokeAssemblyEditor() {
        this.controller.invokeAssemblyEditor();
    }

    public void addProjectWsdlImport() {
        SCAControllerContextHelper context = new SCAControllerContextHelper(this.controller.getProject(), this.controller);
        SCAControllerInterfaceImplHelper.addWsdlImport(context, "project_properties.wsdl", this.project.getProjectModel().getNamespace());
    }

    public void removeProjectWsdlImport() {
        SCAControllerContextHelper context = new SCAControllerContextHelper(this.controller.getProject(), this.controller);
        SCAControllerInterfaceImplHelper.removeWsdlImport(context, this.project.getProjectModel().getNamespace());
    }

    public boolean existsProjectWsdlImport() {
        SCAControllerContextHelper context = new SCAControllerContextHelper(this.controller.getProject(), this.controller);
        return SCAControllerInterfaceImplHelper.doesImportExist(context, "project_properties.wsdl", this.project.getProjectModel().getNamespace());
    }

    public void cleanWsdlImports(@NotNull List<String> wsdlLocation) {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.cleanWsdlImports must not be null");
        }
        throw new UnsupportedOperationException("'Clean wsdl imports' is an unsupported operation in Jdeveloper");
    }

    public Sequence<String> getServiceEntrypoints() {
        return CollectionUtils.asSequence(this.controller.getServiceEntrypoints());
    }

    public Sequence<String> getExternalReferences() {
        return CollectionUtils.asSequence(this.controller.getExternalReferences());
    }

    public void addComponentTypeProperty(String componentName, String serviceOrReferenceName, ScaPropertyInfo propInfo) {
        this.controller.addComponentTypeProperty(componentName, serviceOrReferenceName, this.convert(propInfo));
    }

    public ScaPropertyInfo getComponentTypePropertyInfo(String componentName, String serviceOrReferenceName, String propertyName) {
        PropertyInfo propertyInfo = this.controller.getComponentTypePropertyInfo(componentName, serviceOrReferenceName, propertyName);
        return propertyInfo != null ? Utils.convert(propertyInfo) : null;
    }

    public void deleteComponentTypeProperty(String componentName, String propertyName, String serviceOrReferenceName) {
        this.controller.deleteComponentTypeProperty(componentName, propertyName, serviceOrReferenceName);
    }

    public boolean isNameUniqueWithinComponent(String componentName, String serviceName) {
        return this.controller.isNameUniqueWithinComponent(componentName, serviceName);
    }

    public void deleteService(String componentName, String serviceName) {
        this.controller.deleteService(componentName, serviceName);
        this.touch(componentName);
    }

    public void deleteComponent(String componentName) {
        this.controller.deleteComponent(componentName);
        this.dirtyComponents.remove(componentName);
    }

    public void removeComponentFromComposite(@NotNull Process process, @NotNull String componentName) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.removeComponentFromComposite must not be null");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.removeComponentFromComposite must not be null");
        }
        ScaControllerContext.getInstance().addProcessToKeep(process);
        this.controller.deleteComponent(componentName);
        this.dirtyComponents.remove(componentName);
        ScaControllerContext.getInstance().removeProcessToKeep(process);
    }

    public void createComponent(String componentName, String type, String sourcePath) {
        try {
            this.controller.createComponent(componentName, type, sourcePath);
        }
        catch (SCAInvalidFileNameException e) {
            throw new IllegalArgumentException(e);
        }
        this.touch(componentName);
    }

    public void createComponent(String componentName, String componentType, String definitionInfo, String serviceName, ScaWsdlInfo interfaceInfo) {
        try {
            this.controller.createComponent(componentName, componentType, definitionInfo, serviceName, (InterfaceInfo)this.convert(interfaceInfo));
        }
        catch (SCAInvalidFileNameException e) {
            throw new IllegalArgumentException(e);
        }
        this.touch(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(String componentName, String serviceName, ScaWsdlInfo wsdlInfo) {
        PrintStream stdErr = null;
        try {
            stdErr = this.replaceStdError(StreamUtils.nullOutputStream());
            this.addService0(componentName, serviceName, wsdlInfo);
            for (int count = 5; this.controller.isNameUniqueWithinComponent(componentName, serviceName) && count > 0; --count) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.addService0(componentName, serviceName, wsdlInfo);
            }
        }
        finally {
            this.replaceStdError(stdErr);
        }
        this.touch(componentName);
    }

    public void addReference(String componentName, String referenceName, ScaWsdlInfo wsdlInfo) {
        this.controller.addReference(componentName, referenceName, (InterfaceInfo)this.convert(wsdlInfo));
        this.touch(componentName);
    }

    public Map<String, String> getImplementationSources(String componentType) {
        return this.controller.getImplementationSources(componentType);
    }

    public List<String> getComponentServices(String componentName) {
        return (List)Cast.force(this.controller.getComponentServices(componentName));
    }

    public List<String> getComponentReferenceTarget(String componentName, String referenceName) {
        return this.controller.getComponentReferenceTarget(componentName, referenceName);
    }

    public List<String> getComponentReferences(String componentName) {
        return new MySCAControllerContext(this.jDevProject, this.controller).getComponentReferences(componentName);
    }

    public List<String> getWireSourcesByTarget(@NotNull String primaryName, @Nullable String secondaryName) {
        if (primaryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.getWireSourcesByTarget must not be null");
        }
        if (this.controller instanceof SCAControllerImpl) {
            return ((SCAControllerImpl)this.controller).getWireSourcesByTarget(primaryName, secondaryName);
        }
        return Collections.emptyList();
    }

    public void addWire(String sourceComponent, String sourceReference, String targetComponent, String targetService) {
        this.controller.addWire(sourceComponent, sourceReference, targetComponent, targetService);
    }

    public void deleteReference(String componentName, String referenceName) {
        this.controller.deleteReference(componentName, referenceName);
        this.touch(componentName);
    }

    public void addCompositeProperty(String componentName, ScaPropertyInfo propInfo) {
        this.controller.addComponentProperty(componentName, this.convert(propInfo));
    }

    public void deleteCompositeProperty(String componentName, String propertyName) {
        this.controller.deleteCompositeProperty(componentName, propertyName);
    }

    public ScaWsdlInfo getWsdlInfoForName(String name, String linkName) {
        return this.convert(this.controller.getWsdlInfoForName(name, linkName));
    }

    public void updateService(String componentName, String oldServiceName, String newServiceName, ScaWsdlInfo wsdlInfo) {
        this.controller.updateService(componentName, oldServiceName, newServiceName, (InterfaceInfo)this.convert(wsdlInfo));
        this.touch(componentName);
    }

    public String addServiceEntrypoint(String sourceServiceName, ScaWsdlInfo wsdlInfo) {
        return this.controller.addServiceEntrypoint(null, sourceServiceName, (InterfaceInfo)this.convert(wsdlInfo));
    }

    public String addServiceEntrypoint(String sourceServiceName, ScaWsdlInfo wsdlInfo, ScaBindingInfo bindingInfo) {
        return this.controller.addServiceEntrypoint(null, sourceServiceName, (InterfaceInfo)this.convert(wsdlInfo), this.convert(wsdlInfo, bindingInfo));
    }

    public void updateServiceEntrypoint(String oldServiceName, String newServiceName, ScaWsdlInfo wsdlInfo) {
        this.controller.updateServiceEntrypoint(oldServiceName, newServiceName, (InterfaceInfo)this.convert(wsdlInfo));
    }

    public void deleteServiceEntrypoint(String serviceName) {
        this.controller.deleteServiceEntrypoint(serviceName);
    }

    public void deleteExternalReference(String referenceName) {
        this.controller.deleteExternalReference(referenceName);
    }

    public void addEventSubscription(String componentName, ScaEventInfo eventInfo) {
        this.controller.addEventSubscription(componentName, this.convert(eventInfo));
        this.touch(componentName);
    }

    public void deleteEventSubscription(String componentName, ScaEventInfo eventInfo) {
        this.controller.deleteEventSubscription(componentName, this.convert(eventInfo));
        this.touch(componentName);
    }

    public void addEventPublish(String componentName, ScaEventInfo eventInfo) {
        this.controller.addEventPublish(componentName, this.convert(eventInfo));
        this.touch(componentName);
    }

    public void deleteEventPublish(String componentName, ScaEventInfo eventInfo) {
        this.controller.deleteEventPublish(componentName, this.convert(eventInfo));
        this.touch(componentName);
    }

    public Sequence<ScaEventInfo> getEventSubscriptions(String componentName) {
        return this.convert(this.controller.getEventSubscriptions(componentName));
    }

    public Sequence<ScaEventInfo> getEventPublishes(String componentName) {
        return this.convert(this.controller.getEventPublishes(componentName));
    }

    public void commitChanges() {
        for (String componentName : this.dirtyComponents) {
            this.controller.save(componentName);
        }
        this.dirtyComponents.clear();
    }

    public void addExternalReference(String referenceName, ScaWsdlInfo wsdlInfo, ScaBindingInfo bindingInfo) {
        this.controller.addExternalReference(referenceName, (InterfaceInfo)this.convert(wsdlInfo), this.convert(wsdlInfo, bindingInfo));
    }

    private void addService0(String componentName, String serviceName, ScaWsdlInfo wsdlInfo) {
        try {
            this.controller.addService(componentName, serviceName, (InterfaceInfo)this.convert(wsdlInfo));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private PrintStream replaceStdError(OutputStream outputStream) {
        PrintStream stdErr = System.err;
        if (outputStream != null) {
            try {
                System.setErr(new PrintStream(outputStream));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return stdErr;
    }

    private Sequence<ScaEventInfo> convert(EventInfo[] eventInfos) {
        return eventInfos == null ? CollectionUtils.emptySequence() : CollectionUtils.asSequence(eventInfos).map(new Function<EventInfo, ScaEventInfo>(){

            @Override
            public ScaEventInfo eval(EventInfo value) {
                return JdevScaController.this.convert(value);
            }
        });
    }

    private BindingInfo convert(@NotNull ScaWsdlInfo context, @NotNull ScaBindingInfo bindingInfo) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.convert must not be null");
        }
        if (bindingInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController.convert must not be null");
        }
        if (bindingInfo.type.equals("jca")) {
            ScaBindingInfoJca bindingJca = (ScaBindingInfoJca)bindingInfo;
            return new BindingInfoJCA("jca", null, bindingJca.config);
        }
        if (bindingInfo.type.equals("wsif")) {
            ScaBindingInfoWSIF infoWSIF = (ScaBindingInfoWSIF)bindingInfo;
            return new BindingInfoWSIF("wsif", infoWSIF.portName, infoWSIF.port);
        }
        if (bindingInfo.type.equals("ws")) {
            ScaBindingInfoWs bindingWs = (ScaBindingInfoWs)bindingInfo;
            return new BindingInfoWS("ws", bindingWs.portName, context.requestPortType, bindingWs.concreteWsdlLocation);
        }
        if (bindingInfo.type.equals("direct")) {
            return new BindingInfoDirect();
        }
        return null;
    }

    private ScaWsdlInfo convert(WsdlInfo info) {
        return new ScaWsdlInfo(info.getWsdlLocation(), info.getRequestPorttype(), info.getReplyPorttype());
    }

    private PropertyInfo convert(ScaPropertyInfo p) {
        return new PropertyInfo(p.name, p.type, p.many, p.source, p.override == null ? null : p.override.scaName, p.value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Project getJDevProject() {
        Project jdevProject = Platform.getAdapterService().adaptTo(this.project, Project.class);
        if (jdevProject == null) {
            throw new IllegalStateException("Cannot resolve JDev project for: " + this.project);
        }
        Project project = jdevProject;
        if (project == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevScaController.getJDevProject must not return null");
        }
        return project;
    }

    private WsdlInfo convert(ScaWsdlInfo wsdlInfo) {
        return new WsdlInfo(wsdlInfo.location, wsdlInfo.requestPortType, wsdlInfo.replyPortType);
    }

    private EventInfo convert(ScaEventInfo eventInfo) {
        EventInfo scaEventInfo = new EventInfo(eventInfo.namespace, eventInfo.name, eventInfo.subscriptionConsistency.text(), eventInfo.filter, (MapperNSResolver)(eventInfo.filterNamespaces == null ? null : new NamespaceResolverAdapter(eventInfo.filterNamespaces)), eventInfo.runAsRoles);
        if (eventInfo.edlFile != null) {
            try {
                scaEventInfo.setEdlUrl(new URL(this.scaProject.getProjectRoot(), eventInfo.edlFile));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("illegal edlFile name: " + eventInfo.edlFile);
            }
        }
        return scaEventInfo;
    }

    private ScaEventInfo convert(EventInfo src) {
        return ScaEventInfo.createEventInfo((String)src.getNamespace(), (String)src.getName()).runAsRoles(src.getRunAsRoles()).consistency(ScaEventInfo.Consistency.fromString((String)src.getSubscriptionConsistency()));
    }

    private void touch(String componentName) {
        this.dirtyComponents.add(componentName);
    }

    private class SCAControllerContextHelper
    extends SCAControllerContext {
        public SCAControllerContextHelper(Project project, SCAController scon) {
            super(project, scon);
        }

        public void beginTran() {
            super.getCompositeDocument(true);
        }

        public void commitTran() {
            super.commitTransactions(null);
        }

        public void rollbackTran() {
            super.rollbackTransactions(null);
        }
    }

    private static class SCAControllerInterfaceImplHelper
    extends SCAControllerInterfaceImpl {
        private SCAControllerInterfaceImplHelper() {
        }

        static void addWsdlImport(SCAControllerContextHelper sctx, String location, String namespace) {
            try {
                SCAControllerInterfaceImpl.addImport((SCAControllerContext)sctx, (String)location, (String)namespace, (String)"wsdl");
                sctx.commitTran();
            }
            catch (Exception e) {
                sctx.rollbackTran();
            }
        }

        static void removeWsdlImport(SCAControllerContextHelper sctx, String namespace) {
            try {
                SCAControllerInterfaceImpl.removeImportByNamespace((SCAControllerContext)sctx, (String)namespace);
                sctx.commitTran();
            }
            catch (Exception e) {
                sctx.rollbackTran();
            }
        }

        static boolean doesImportExist(SCAControllerContextHelper sctx, String location, String namespace) {
            return SCAControllerInterfaceImpl.doesImportExist((SCAControllerContext)sctx, (String)location, (String)namespace);
        }
    }

    private static class NamespaceResolverAdapter
    implements MapperNSResolver {
        @NotNull
        private final Map<String, URI> namespaces;

        public NamespaceResolverAdapter(@NotNull Map<String, URI> namespaces) {
            if (namespaces == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevScaController$NamespaceResolverAdapter.<init> must not be null");
            }
            this.namespaces = namespaces;
        }

        public String addNSEntry(String s, String s1, int i) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addNSEntry");
        }

        public void addFunctionNSEntries(String[][] strings) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addFunctionNSEntries");
        }

        public void addSourceNSEntries(String[][] strings) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addSourceNSEntries");
        }

        public void addTargetNSEntries(String[][] strings) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addTargetNSEntries");
        }

        public void addStylesheetNSEntries(String[][] strings) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addStylesheetNSEntries");
        }

        public String[][] getFunctionsNSEntries() {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.getFunctionsNSEntries");
        }

        public String[][] getSourceNSEntries() {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.getSourceNSEntries");
        }

        public String[][] getTargetNSEntries() {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.getTargetNSEntries");
        }

        public String[][] getStylesheetNSEntries() {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.getStylesheetNSEntries");
        }

        public String resolveNamespaceURI(String s) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.resolveNamespaceURI");
        }

        public void addNSEntries(String[][] strings) throws NamespaceConflictException {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addNSEntries");
        }

        public String[][] getAllNSEntries() {
            String[][] result = new String[this.namespaces.size()][];
            int counter = 0;
            for (Map.Entry<String, URI> entry : this.namespaces.entrySet()) {
                result[counter++] = new String[]{entry.getKey(), String.valueOf(entry.getValue())};
            }
            return result;
        }

        public String addNSEntry(String s, String s1) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.addNSEntry");
        }

        public String removeNSEntry(String s) {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.removeNSEntry");
        }

        public void removeAllNSEntries() {
            throw new UnsupportedOperationException("oracle.bpm.fusion.sca.JdevScaController.NamespaceResolver.removeAllNSEntries");
        }

        public String resolveNamespacePrefix(String s) {
            return String.valueOf(this.namespaces.get(s));
        }
    }

    private static class MySCAControllerContext
    extends SCAControllerContext {
        public MySCAControllerContext(Project project, SCAController scon) {
            super(project, scon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> getComponentReferences(String componentName) {
            try {
                ArrayList<String> retlist = new ArrayList<String>();
                XMLDocument ctypDoc = this.getComponentTypeDocument(componentName, false);
                Element ctypRoot = ctypDoc.getDocumentElement();
                NodeList nodes = ctypRoot.getElementsByTagNameNS("http://xmlns.oracle.com/sca/1.0", "reference");
                int ncnt = nodes.getLength();
                for (int ii = 0; ii < ncnt; ++ii) {
                    Element cnode = (Element)nodes.item(ii);
                    retlist.add(cnode.getAttributeNS(SCAControllerContext.ATTRIBUTE_NAMESPACE_URI, "name"));
                }
                ArrayList<String> arrayList = retlist;
                return arrayList;
            }
            finally {
                this.releaseComponentTypeReadLock(componentName);
            }
        }
    }
}

