/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.JaxbAbstractCompositeAccessor;
import oracle.bpm.project.catalog.composite.jaxb.Composite;
import oracle.bpm.project.catalog.composite.jaxb.CompositeUtils;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.resources.Msg;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.fabric.addin.CompositeModel;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public final class JdevJaxbCompositeAccessor
extends JaxbAbstractCompositeAccessor {
    public JdevJaxbCompositeAccessor(@NotNull oracle.bpm.project.model.Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevJaxbCompositeAccessor.<init> must not be null");
        }
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadComposite() throws CompositeAccessorException {
        JAXBElement element;
        Project devProject = this.getJDevProject();
        CompositeModel model = CompositeModel.getCompositeModel((Project)devProject);
        if (devProject != null && model != null) {
            try {
                model.acquireReadLock();
                element = CompositeUtils.loadScaElement((Document)model.getDocument(), Composite.class);
            }
            catch (JAXBException e) {
                try {
                    element = CompositeUtils.loadScaElement((InputStream)JdevJaxbCompositeAccessor.serializeModel(model), Composite.class);
                }
                catch (JAXBException retryEx) {
                    throw new CompositeAccessorException(ProjectCatalogMsg.ERROR_LOADING_COMPOSITE_DATA, (Throwable)e);
                }
            }
            finally {
                model.releaseReadLock();
            }
            assert (element != null) : "if element is null an exception should have been thrown";
        } else {
            throw new CompositeAccessorException((Msg)ProjectCatalogMsg.INVALID_COMPOSITE_DATA);
        }
        this.setJaxbModel((Composite)element.getValue());
    }

    private static InputStream serializeModel(CompositeModel model) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            Document document = model.getDocument();
            if (document.getDoctype() != null) {
                t.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
            }
            t.transform(new DOMSource(document), new StreamResult(baos));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private Project getJDevProject() throws CompositeAccessorException {
        Project result;
        oracle.bpm.project.model.Project project = this.getProject();
        ProjectRepository repository = project.getRepository();
        if (repository == null) {
            result = null;
        } else {
            result = Platform.getAdapterService().adaptTo(project, Project.class);
            if (result == null) {
                throw new CompositeAccessorException(ProjectCatalogMsg.CANNOT_LOAD_JDEV_PROJECT((String)project.getName()));
            }
        }
        return result;
    }
}

