/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Function;
import oracle.bpm.fusion.sca.JdevComponentTypesAccessor;
import oracle.bpm.fusion.sca.Utils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.common.SpringComponentUtils;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectRepository;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.fabric.addin.CompositeModel;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.JavaInterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.model.JavaInterface;
import oracle.tip.tools.ide.fabric.model.SCAComponent;
import oracle.tip.tools.ide.fabric.model.SCAComponentType;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAImplementation;
import oracle.tip.tools.ide.fabric.model.SCAImports;
import oracle.tip.tools.ide.fabric.model.SCAInterface;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilderException;
import oracle.tip.tools.ide.fabric.model.SCAReference;
import oracle.tip.tools.ide.fabric.model.SCAService;
import oracle.tip.tools.ide.fabric.model.WSDLInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdevCompositeAccessor
extends CompositeAccessor {
    private JdevComponentTypesAccessor componentTypesAccessor;
    private SCAComposite scaComposite;
    private static final String EMPTY = "";
    private static final QName HUMAN_TASK_INTERFACE_QNAME = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService");
    private static final String BUSINESS_RULE_INTERFACE_NAMESPACE = "http://xmlns.oracle.com/RuleDictionary/";
    private static final String BUSINESS_RULE_INTERFACE_NAME = "IDecisionService";

    public JdevCompositeAccessor(@NotNull oracle.bpm.project.model.Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor.<init> must not be null");
        }
        super(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CompositeInfo parseComposite() throws CompositeAccessorException {
        this.loadComposite();
        CompositeInfo compositeInfo = new CompositeInfo(this.getCompositeReferences(), this.getCompositeServices(), this.getCompositeComponents(), this.getCompositeImports());
        if (compositeInfo == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.parseComposite must not return null");
        }
        return compositeInfo;
    }

    public void reload() {
        if (this.componentTypesAccessor != null) {
            this.componentTypesAccessor.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeReferences() {
        SCAComposite composite = this.getScaComposite();
        List scaReferences = composite != null ? composite.getReferences() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaReferences, new Function<SCAReference, CompositeInterface>(){

            @Override
            public CompositeInterface eval(SCAReference scaReference) {
                return CompositeAccessor.createInterface((CompositeAccessor.CompositeObjectContainer)new ElementContainer(JdevCompositeAccessor.this.getVFileSystemProject(), JdevCompositeAccessor.this.componentTypesAccessor, scaReference), (String)scaReference.getName(), null, (CatalogInterfaceType)CatalogInterfaceType.SERVICE, null);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeReferences must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeServices() {
        SCAComposite composite = this.getScaComposite();
        List scaServices = composite != null ? composite.getServices() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaServices, new Function<SCAService, CompositeInterface>(){

            @Override
            public CompositeInterface eval(SCAService scaService) {
                return CompositeAccessor.createInterface((CompositeAccessor.CompositeObjectContainer)new ElementContainer(JdevCompositeAccessor.this.getVFileSystemProject(), JdevCompositeAccessor.this.componentTypesAccessor, scaService), (String)scaService.getName(), null, (CatalogInterfaceType)CatalogInterfaceType.REFERENCE, null);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeServices must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeComponent> getCompositeComponents() {
        SCAComposite composite = this.getScaComposite();
        List componentList = composite != null ? composite.getComponents() : new ArrayList();
        Iterable iterable = this.nonNullIterable(componentList, new Function<SCAComponent, CompositeComponent>(){

            @Override
            public CompositeComponent eval(SCAComponent scaComponent) {
                return JdevCompositeAccessor.this.createComponent(scaComponent);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeComponents must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeImport> getCompositeImports() {
        SCAComposite composite = this.getScaComposite();
        List scaImports = composite != null ? composite.getImports() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaImports, new Function<SCAImports, CompositeImport>(){

            @Override
            public CompositeImport eval(SCAImports value) {
                return JdevCompositeAccessor.this.createImport(value);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeImports must not return null");
        }
        return iterable;
    }

    private CompositeImport createImport(SCAImports value) {
        String namespace = Str.null2empty(value.getNamespace().toString());
        String location = Str.null2empty(value.getLocation());
        return new CompositeImport(namespace, location, value.getImportType());
    }

    private void loadComposite() throws CompositeAccessorException {
        Project devProject = this.getJDevProject();
        try {
            if (devProject != null && CompositeModel.getCompositeModel((Project)devProject) != null) {
                this.scaComposite = SCAModelBuilder.getSCAModelBuilder((Project)devProject).reloadSCAComposite();
                if (this.componentTypesAccessor == null) {
                    SCAController scaController = SCAControllerImpl.getController((Project)devProject);
                    ProjectLoader loader = this.getProject().getLoader();
                    assert (loader != null);
                    VFileSystem fileSystem = loader.getProjectFileSystem().getDataFileSystem();
                    this.componentTypesAccessor = new JdevComponentTypesAccessor(fileSystem, scaController);
                }
            }
        }
        catch (SCAModelBuilderException e) {
            throw new CompositeAccessorException(ProjectCatalogMsg.ERROR_LOADING_COMPOSITE_DATA, (Throwable)e);
        }
    }

    @Nullable
    private SCAComposite getScaComposite() {
        return this.scaComposite;
    }

    @Nullable
    private CompositeComponent createComponent(@NotNull SCAComponent scaComponent) {
        if (scaComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor.createComponent must not be null");
        }
        String name = scaComponent.getName();
        SCAImplementation implementation = scaComponent.getImplementation();
        SCAComponentType type = scaComponent.getComponentType();
        String srcLocation = implementation != null ? implementation.getSrcURI().toString() : null;
        CompositeServiceType serviceType = this.getType(implementation);
        Map properties = Collections.emptyMap();
        CompositeComponent component = new CompositeComponent(name, serviceType, srcLocation, properties);
        if (implementation != null) {
            List references;
            VFileSystem fileSystemProject = this.getVFileSystemProject();
            List services = type.getServices();
            if (services != null) {
                for (SCAService service : services) {
                    CompositeInterface externalInterface;
                    ElementContainer elemContainer = new ElementContainer(fileSystemProject, this.componentTypesAccessor, name, service);
                    Map<Object, Object> propertyInfoMap = Collections.emptyMap();
                    if (CompositeServiceType.BPMN == serviceType) {
                        propertyInfoMap = this.buildPropertyMap(scaComponent.getName(), service.getName());
                    }
                    if ((externalInterface = JdevCompositeAccessor.createInterface((CompositeAccessor.CompositeObjectContainer)elemContainer, (String)name, (String)service.getName(), (CatalogInterfaceType)CatalogInterfaceType.SERVICE, propertyInfoMap)) == null) continue;
                    component.addService(externalInterface);
                }
            }
            if ((references = type.getReferences()) != null) {
                for (SCAReference reference : references) {
                    ElementContainer elemContainer = new ElementContainer(fileSystemProject, this.componentTypesAccessor, name, reference);
                    Map propertyInfoMap = Collections.emptyMap();
                    CompositeInterface externalInterface = JdevCompositeAccessor.createInterface((CompositeAccessor.CompositeObjectContainer)elemContainer, (String)name, (String)reference.getName(), (CatalogInterfaceType)CatalogInterfaceType.REFERENCE, propertyInfoMap);
                    if (externalInterface == null) continue;
                    component.addReference(externalInterface);
                }
            }
        }
        return component;
    }

    private Map<String, ScaPropertyInfo> buildPropertyMap(String componentName, String serviceOrReferenceName) {
        Map<String, ScaPropertyInfo> result;
        List<PropertyInfo> propertyInfos = this.componentTypesAccessor.getComponentTypeProperties(componentName, serviceOrReferenceName);
        if (propertyInfos != null && !propertyInfos.isEmpty()) {
            result = new HashMap<String, ScaPropertyInfo>();
            for (PropertyInfo propertyInfo : propertyInfos) {
                ScaPropertyInfo scaPropertyInfo = Utils.convert(propertyInfo);
                result.put(scaPropertyInfo.name, scaPropertyInfo);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Project getJDevProject() throws CompositeAccessorException {
        Project result;
        oracle.bpm.project.model.Project project = this.getProject();
        ProjectRepository repository = project.getRepository();
        if (repository == null) {
            result = null;
        } else {
            result = Platform.getAdapterService().adaptTo(project, Project.class);
            if (result == null) {
                throw new CompositeAccessorException(ProjectCatalogMsg.CANNOT_LOAD_JDEV_PROJECT((String)project.getName()));
            }
        }
        return result;
    }

    private CompositeServiceType getType(@Nullable SCAImplementation type) {
        if (type == null) {
            return CompositeServiceType.UNKNOWN;
        }
        return CompositeServiceType.parse((String)type.getImplementationType());
    }

    private static class ElementContainer
    implements CompositeAccessor.CompositeObjectContainer {
        private String componentName;
        private JdevComponentTypesAccessor componentTypeAccessor;
        private SCAReference reference;
        private SCAService service;
        private VFileSystem vfileSystem;

        ElementContainer(@NotNull VFileSystem vfileSystem, JdevComponentTypesAccessor componentTypeAccessor, @NotNull SCAReference reference) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.componentTypeAccessor = null;
            this.reference = null;
            this.service = null;
            this.vfileSystem = null;
            this.componentTypeAccessor = componentTypeAccessor;
            this.reference = reference;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, JdevComponentTypesAccessor componentTypeAccessor, @NotNull SCAService service) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (service == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.componentTypeAccessor = null;
            this.reference = null;
            this.service = null;
            this.vfileSystem = null;
            this.componentTypeAccessor = componentTypeAccessor;
            this.service = service;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, JdevComponentTypesAccessor componentTypeAccessor, @NotNull String componentName, @NotNull SCAReference reference) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.componentTypeAccessor = null;
            this.reference = null;
            this.service = null;
            this.vfileSystem = null;
            this.componentTypeAccessor = componentTypeAccessor;
            this.reference = reference;
            this.componentName = componentName;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, JdevComponentTypesAccessor componentTypeAccessor, @NotNull String componentName, @NotNull SCAService service) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (service == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.componentTypeAccessor = null;
            this.reference = null;
            this.service = null;
            this.vfileSystem = null;
            this.componentTypeAccessor = componentTypeAccessor;
            this.service = service;
            this.componentName = componentName;
            this.vfileSystem = vfileSystem;
        }

        public String getName() {
            return this.service != null ? this.service.getName() : this.reference.getName();
        }

        public QName getInterfaceQName() {
            SCAInterface scaInterface = this.getInterface();
            if (scaInterface instanceof WSDLInterface) {
                return ((WSDLInterface)this.getInterface()).getInterfaceQName();
            }
            if (scaInterface instanceof JavaInterface) {
                JavaInterface javaInterface = (JavaInterface)scaInterface;
                return SpringComponentUtils.buildQName((String)javaInterface.getInterfaceName());
            }
            return null;
        }

        public QName getCallbankInterfaceQName() {
            SCAInterface scaInterface = this.getInterface();
            if (scaInterface instanceof WSDLInterface) {
                return ((WSDLInterface)this.getInterface()).getCallbankInterfaceQName();
            }
            if (scaInterface instanceof JavaInterface) {
                JavaInterface javaInterface = (JavaInterface)scaInterface;
                return SpringComponentUtils.buildQName((String)javaInterface.getCallbackInterfaceName());
            }
            return null;
        }

        public VFileSystem getVFileSystem() {
            return this.vfileSystem;
        }

        public List<URI> getWsdl() {
            String name;
            URL url = null;
            String linkName = null;
            if (this.componentName == null) {
                name = this.getName();
            } else {
                name = this.componentName;
                linkName = this.getName();
            }
            InterfaceInfo interfaceInfo = this.componentTypeAccessor.getInterfaceInfoForName(name, linkName);
            if (interfaceInfo instanceof JavaInterfaceInfo) {
                JavaInterfaceInfo javaInterfaceInfo = (JavaInterfaceInfo)interfaceInfo;
                String interfaceName = javaInterfaceInfo.getJavaInterfaceName();
                VFile file = this.vfileSystem.createFile(SpringComponentUtils.buildWsdlFileName((String)interfaceName));
                try {
                    url = file.toURL();
                }
                catch (IOException e1) {
                    url = null;
                }
            } else {
                assert (interfaceInfo instanceof WsdlInfo);
                WsdlInfo wsdlInfo = (WsdlInfo)interfaceInfo;
                String location = wsdlInfo.getWsdlLocation();
                if (location != null) {
                    try {
                        url = new URL(location);
                    }
                    catch (MalformedURLException e) {
                        VFile file = this.vfileSystem.createFile(location);
                        try {
                            url = file.toURL();
                        }
                        catch (IOException e1) {
                            url = null;
                        }
                    }
                }
            }
            if (url == null && this.service != null) {
                url = this.service.getWsdlUrl();
            }
            try {
                ArrayList<URI> ret = new ArrayList<URI>();
                ret.add(url.toURI());
                return ret;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public CompositeServiceType getInterfaceType() {
            QName qName;
            CompositeServiceType result = CompositeServiceType.WEB_SERVICE;
            SCAInterface scaInterface = this.getInterface();
            if (scaInterface != null && scaInterface instanceof WSDLInterface && (qName = ((WSDLInterface)this.getInterface()).getInterfaceQName()) != null) {
                if (qName.equals(HUMAN_TASK_INTERFACE_QNAME)) {
                    result = CompositeServiceType.HUMAN_TASK;
                } else {
                    String namespace = qName.getNamespaceURI();
                    String localPart = qName.getLocalPart();
                    if (namespace.startsWith(JdevCompositeAccessor.BUSINESS_RULE_INTERFACE_NAMESPACE) && localPart.equals(JdevCompositeAccessor.BUSINESS_RULE_INTERFACE_NAME)) {
                        result = CompositeServiceType.BUSINESS_RULE;
                    }
                }
            }
            CompositeServiceType compositeServiceType = result;
            if (compositeServiceType == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.getInterfaceType must not return null");
            }
            return compositeServiceType;
        }

        private SCAInterface getInterface() {
            return this.service != null ? this.service.getInterface() : this.reference.getInterface();
        }
    }
}

