/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util.lookup;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.security.SecurityRemoteService;
import oracle.bpm.pml.service.util.lookup.WasLookupService;
import oracle.bpm.pml.service.util.lookup.WebsphereClassLoaderFactory;
import oracle.ide.net.URLPath;
import oracle.rc.asadapter.websphere.Websphere7Utils;
import oracle.rc.asadapter.websphere.connection.Websphere7Descriptor;
import org.jetbrains.annotations.NotNull;

public class StudioWasLookupService
extends WasLookupService {
    private final Websphere7Descriptor descriptor;
    private Properties oldProps;
    private ClassLoader prev;
    private static final String IBM_CORBA_CONFIGURL = "com.ibm.CORBA.ConfigURL";

    public StudioWasLookupService(@NotNull Websphere7Descriptor connectionDescriptor) {
        if (connectionDescriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/StudioWasLookupService.<init> must not be null");
        }
        this.descriptor = connectionDescriptor;
    }

    @Override
    public HistoryService lookupRemoteHistoryService(@NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        HistoryService result;
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/StudioWasLookupService.lookupRemoteHistoryService must not be null");
        }
        try {
            this.beforeLookup();
            result = super.lookupRemoteHistoryService(applicationServerConnection);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        finally {
            this.afterLookup();
        }
        return result;
    }

    @Override
    public SecurityRemoteService lookupRemoteSecurityService(@NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        SecurityRemoteService result;
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/StudioWasLookupService.lookupRemoteSecurityService must not be null");
        }
        try {
            this.beforeLookup();
            result = super.lookupRemoteSecurityService(applicationServerConnection);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        finally {
            this.afterLookup();
        }
        return result;
    }

    private static Properties push(ClassLoader loader, Properties sysProps) {
        Properties oldProps = new Properties();
        if (sysProps != null) {
            for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
                String key = (String)entry.getKey();
                String newval = (String)entry.getValue();
                String oldval = System.getProperty(key);
                if (oldval == null) {
                    oldval = "null-value";
                }
                oldProps.setProperty(key, oldval);
                System.setProperty(key, newval);
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
        return oldProps;
    }

    private static void pop(ClassLoader prev, Properties oldProps) {
        if (oldProps != null) {
            for (Map.Entry<Object, Object> entry : oldProps.entrySet()) {
                String key = (String)entry.getKey();
                String oldval = (String)entry.getValue();
                if ("null-value".equals(oldval)) {
                    System.clearProperty(key);
                    continue;
                }
                System.setProperty(key, oldval);
            }
        }
        Thread.currentThread().setContextClassLoader(prev);
    }

    private void beforeLookup() throws IOException {
        this.prev = Thread.currentThread().getContextClassLoader();
        URLPath wasRuntimes = Websphere7Utils.getClientClassPath((Websphere7Descriptor)this.descriptor);
        String fileUrl = this.findOrCreateFile(this.descriptor);
        Properties sysProps = new Properties();
        sysProps.setProperty(IBM_CORBA_CONFIGURL, fileUrl);
        sysProps.setProperty("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        ClassLoader loader = WebsphereClassLoaderFactory.getClassLoader(wasRuntimes);
        this.oldProps = StudioWasLookupService.push(loader, sysProps);
    }

    private void afterLookup() {
        StudioWasLookupService.pop(this.prev, this.oldProps);
    }

    private String findOrCreateFile(Websphere7Descriptor descriptor) throws IOException {
        return new File(descriptor.getSecurityPath(), "sas.client.props").toURI().toURL().toString();
    }
}

