/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util.lookup;

import oracle.bpm.pml.service.util.lookup.LookupService;
import oracle.bpm.pml.service.util.lookup.StudioWasLookupService;
import oracle.bpm.pml.service.util.lookup.WasLookupService;
import oracle.bpm.pml.service.util.lookup.WlsLookupService;
import oracle.rc.asadapter.websphere.connection.Websphere7Descriptor;
import org.jetbrains.annotations.Nullable;

public class LookupServiceFactory {
    public static LookupService getLookupService() {
        LookupService result = LookupServiceFactory.isWebsphere() ? LookupServiceFactory.getWasLookupHelper() : LookupServiceFactory.getWlsLookupHelper();
        return result;
    }

    public static synchronized LookupService getStudioLookupHelper(@Nullable Websphere7Descriptor connectionDescriptor) {
        if (connectionDescriptor != null) {
            return new StudioWasLookupService(connectionDescriptor);
        }
        return LookupServiceFactory.getWlsLookupHelper();
    }

    private static LookupService getWasLookupHelper() {
        return new WasLookupService();
    }

    private static LookupService getWlsLookupHelper() {
        return new WlsLookupService();
    }

    private static boolean isWebsphere() {
        try {
            Class.forName("com.ibm.websphere.naming.WsnInitialContextFactory");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

