/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util.lookup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.security.SecurityRemoteService;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.pml.IHistoryService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.config.BPMIdentityConfigService;
import oracle.tip.pc.services.identity.config.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupService {
    public BPMIdentityService lookupLocalIdentityService(String serverUrl) throws MetadataException {
        BPMIdentityService identityService = null;
        String serverURL = serverUrl;
        if (serverURL == null) {
            serverURL = "http://localhost:7001";
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> _properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "SOAP");
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, serverURL);
        try {
            BPMIdentityConfigService identityConfigService = WorkflowServiceClientFactory.getSOAPIdentityConfigServiceClient(_properties, null);
            Configuration configuration = identityConfigService.getConfiguration(identityConfigService.getDefaultRealmName());
            if (configuration != null) {
                identityService = WorkflowServiceClientFactory.getSOAPIdentityServiceClient((String)configuration.getRealmName(), _properties, null);
            }
        }
        catch (BPMIdentityException e) {
            throw new MetadataException((Throwable)e);
        }
        return identityService;
    }

    public SecurityRemoteService lookupLocalSecurityService(@NotNull String serverUrl) throws MetadataException {
        if (serverUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupLocalSecurityService must not be null");
        }
        BPMServiceClientFactory bpmServiceClientFactory = this.getBPMServiceClientFactory(serverUrl, null, null);
        return this.lookupSecurityService(bpmServiceClientFactory);
    }

    public HistoryService lookupLocalHistoryService(@NotNull String jndiServerUrl) throws MetadataException {
        if (jndiServerUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupLocalHistoryService must not be null");
        }
        BPMServiceClientFactory bpmServiceClientFactory = this.getBPMServiceClientFactory(jndiServerUrl, null, null);
        return this.getHistoryService(bpmServiceClientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityRemoteService lookupRemoteSecurityService(@NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupRemoteSecurityService must not be null");
        }
        BPMServiceClientFactory bpmServiceClientFactory = this.getRemoteBPMServiceClientFactory(applicationServerConnection);
        String userName = applicationServerConnection.getUserName();
        char[] password = applicationServerConnection.getPassword();
        SecurityRemoteService securityRemoteService = null;
        try {
            securityRemoteService = this.lookupRemoteSecurityService(userName, password, bpmServiceClientFactory);
        }
        finally {
            Arrays.fill(password, ' ');
        }
        return securityRemoteService;
    }

    public HistoryService lookupRemoteHistoryService(@NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupRemoteHistoryService must not be null");
        }
        BPMServiceClientFactory bpmServiceClientFactory = this.getRemoteBPMServiceClientFactory(applicationServerConnection);
        return this.getHistoryService(bpmServiceClientFactory);
    }

    protected abstract String getProtocol();

    protected abstract String getSecuredProtocol();

    protected void addCustomProperties(@NotNull Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.addCustomProperties must not be null");
        }
    }

    private HistoryService getHistoryService(@NotNull BPMServiceClientFactory bpmServiceClientFactory) {
        if (bpmServiceClientFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.getHistoryService must not be null");
        }
        IHistoryService service = null;
        IBPMServiceClient bpmServiceClient = bpmServiceClientFactory.getBPMServiceClient();
        if (bpmServiceClient != null) {
            service = bpmServiceClient.getHistoryService();
        }
        return service;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private BPMServiceClientFactory getRemoteBPMServiceClientFactory(@NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.getRemoteBPMServiceClientFactory must not be null");
        }
        String protocol = applicationServerConnection.usedSsl() ? this.getSecuredProtocol() : this.getProtocol();
        String serverURL = protocol + applicationServerConnection.getAppServerURL() + ":" + applicationServerConnection.getAppServerPort();
        String soaUserName = applicationServerConnection.getSoaUserName();
        char[] soaPassword = applicationServerConnection.getSoaPassword();
        BPMServiceClientFactory bPMServiceClientFactory = this.getBPMServiceClientFactory(serverURL, soaUserName, soaPassword);
        if (bPMServiceClientFactory == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/util/lookup/LookupService.getRemoteBPMServiceClientFactory must not return null");
        }
        return bPMServiceClientFactory;
    }

    private SecurityRemoteService lookupSecurityService(@NotNull BPMServiceClientFactory bpmServiceClientFactory) throws MetadataException {
        if (bpmServiceClientFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupSecurityService must not be null");
        }
        IBPMUserAuthenticationService authService = bpmServiceClientFactory.getBPMUserAuthenticationService();
        SecurityRemoteService service = null;
        try {
            IBPMContext bpmContext = authService.getBPMContextForAuthenticatedUser();
            IBPMServiceClient bpmServiceClient = bpmServiceClientFactory.getBPMServiceClient();
            if (bpmServiceClient != null) {
                service = new SecurityRemoteService(bpmContext, bpmServiceClient.getSecurityService());
            }
        }
        catch (BPMException e) {
            throw MetadataExceptionFactory.createUserAuthenticationException((Throwable)e);
        }
        return service;
    }

    private SecurityRemoteService lookupRemoteSecurityService(@NotNull String username, @NotNull char[] password, BPMServiceClientFactory bpmServiceClientFactory) throws MetadataException {
        if (username == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupRemoteSecurityService must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.lookupRemoteSecurityService must not be null");
        }
        IBPMUserAuthenticationService authService = bpmServiceClientFactory.getBPMUserAuthenticationService();
        SecurityRemoteService service = null;
        try {
            IBPMContext bpmContext = authService.authenticate(username, password, null);
            IBPMServiceClient bpmServiceClient = bpmServiceClientFactory.getBPMServiceClient();
            if (bpmServiceClient != null) {
                service = new SecurityRemoteService(bpmContext, bpmServiceClient.getSecurityService());
            }
        }
        catch (BPMException e) {
            throw MetadataExceptionFactory.createUserAuthenticationException((Throwable)e);
        }
        return service;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private BPMServiceClientFactory getBPMServiceClientFactory(@NotNull String serverJndiUrl, @Nullable String username, @Nullable char[] password) throws MetadataException {
        if (serverJndiUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/lookup/LookupService.getBPMServiceClientFactory must not be null");
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, serverJndiUrl);
        this.addCustomProperties(properties);
        if (username != null && !username.isEmpty() && password != null) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, username);
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, new String(password));
        }
        BPMServiceClientFactory bPMServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        if (bPMServiceClientFactory == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/util/lookup/LookupService.getBPMServiceClientFactory must not return null");
        }
        return bPMServiceClientFactory;
    }
}

