/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MdDomainImpl;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.service.PmlSecurityCoreService;
import oracle.bpm.pml.service.util.MdProjectUtil;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.mds.core.MDSInstance;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMIdentityType;
import org.jetbrains.annotations.NotNull;

public class SecurityRoleMigration {
    private static final String DEVELOP_ANY_PROJECT = "BPMComposerDeveloper";
    private static final String VIEW_ANY_PROJECT = "BPMComposerViewProject";
    private static final String DESIGN_ANY_PROJECT = "BPMComposerDesigner";
    private static final String DEPLOY_ANY_PROJECT = "BPMComposerDeployer";
    private static final String DOCUMENT_ANY_PROJECT = "BPMComposerDocumentProject";
    private static final String SOA_DESIGNER = "SOADesigner";
    private static final String ADMIN_ANY_PROJECT = "BPMComposerAdmin";
    private static final Map<String, ProjectRole> ROLE_MAPPING;

    public static void migrate(@NotNull MDSInstance mdsInstance, @NotNull PmlSecurityCoreService securityService, @NotNull BPMIdentityService bpmIdentityService) throws MetadataException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.migrate must not be null");
        }
        if (securityService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.migrate must not be null");
        }
        if (bpmIdentityService == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.migrate must not be null");
        }
        MdsFileSystem vfs = new MdsFileSystem(mdsInstance, "/bpm");
        VFile file = vfs.createFile("/migration.txt");
        if (!file.exists()) {
            System.out.println("Migration in progress ...");
            Map<ProjectRole, Set<PmlPrincipal>> userMap = SecurityRoleMigration.getUsers(securityService, bpmIdentityService);
            MdDomainImpl domain = new MdDomainImpl(mdsInstance, ApplicationType.GENERIC_APPLICATION);
            MdTree publicShareTree = domain.browseProject(PublicShareProject.class, null, null);
            Collection publicShares = publicShareTree.toCollection(true);
            for (LocalRef publicShare : publicShares) {
                String projectId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, (MdProject)publicShare.get());
                for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
                    securityService.grantProjectRole(role, projectId, userMap.get(role));
                }
            }
            MdTree templateTree = domain.browseProject(TemplateProject.class, null, null);
            Collection templates = templateTree.toCollection(true);
            PmlPrincipal publicPrincipal = PmlPrincipal.getPublicPrincipal((String)securityService.getApplicationName());
            HashSet<PmlPrincipal> principals = new HashSet<PmlPrincipal>();
            principals.add(publicPrincipal);
            for (LocalRef template : templates) {
                String projectId = MdProjectUtil.createMdProjectFullId(ProjectType.TEMPLATE, (MdProject)template.get());
                securityService.grantProjectRole(ProjectRole.OWNER, projectId, principals);
            }
            VFileOutputStream out = null;
            try {
                out = new VFileOutputStream(file);
                StringBuilder builder = new StringBuilder();
                builder.append("Date:").append(Calendar.getInstance());
                builder.append("Templates migrated:").append(templates.size());
                builder.append(",Public share migrated:").append(templates.size());
                out.write(builder.toString().getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw PersistenceException.createIOException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    vfs.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Map<ProjectRole, Set<PmlPrincipal>> getUsers(@NotNull PmlSecurityCoreService securityService, @NotNull BPMIdentityService identityService) throws PmlSecurityException {
        if (securityService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.getUsers must not be null");
        }
        if (identityService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.getUsers must not be null");
        }
        HashMap<ProjectRole, Set<PmlPrincipal>> userMap = new HashMap<ProjectRole, Set<PmlPrincipal>>();
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            userMap.put(role, new HashSet());
        }
        for (String applicationRole : ROLE_MAPPING.keySet()) {
            String applicationName = SOA_DESIGNER.equals(applicationRole) ? ApplicationContextTypeEnum.SOA_INFRA.value() : securityService.getApplicationName();
            Set<PmlPrincipal> bpmUsers = SecurityRoleMigration.getUsers(identityService, applicationRole, applicationName);
            ProjectRole projectRole = ROLE_MAPPING.get(applicationRole);
            Set users = (Set)userMap.get(projectRole);
            users.addAll(bpmUsers);
        }
        Set ownerUsers = (Set)userMap.get(ProjectRole.OWNER);
        Set editorUsers = (Set)userMap.get(ProjectRole.EDITOR);
        Set viewerUsers = (Set)userMap.get(ProjectRole.VIEWER);
        editorUsers.removeAll(ownerUsers);
        viewerUsers.removeAll(ownerUsers);
        viewerUsers.removeAll(editorUsers);
        return userMap;
    }

    private static Set<PmlPrincipal> getUsers(@NotNull BPMIdentityService identityService, @NotNull String applicationRole, @NotNull String applicationName) throws PmlSecurityException {
        if (identityService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.getUsers must not be null");
        }
        if (applicationRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.getUsers must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/util/SecurityRoleMigration.getUsers must not be null");
        }
        HashSet<PmlPrincipal> result = new HashSet<PmlPrincipal>();
        try {
            Set bpmIdentities = identityService.getGranteesToAppRole(applicationRole, applicationName, true);
            for (BPMIdentity bpmIdentity : bpmIdentities) {
                if (!BPMIdentityType.USER.equals((Object)bpmIdentity.getIdentityType()) && !BPMIdentityType.GROUP.equals((Object)bpmIdentity.getIdentityType())) continue;
                result.add(new PmlPrincipal(bpmIdentity.getName(), applicationName));
            }
            return result;
        }
        catch (BPMIdentityException e) {
            if (e.getErrorCode() == 10526) {
                return result;
            }
            throw PmlSecurityExceptionFactory.createIdentityException((BPMIdentityException)e);
        }
    }

    static {
        HashMap<String, ProjectRole> map = new HashMap<String, ProjectRole>();
        map.put(DEVELOP_ANY_PROJECT, ProjectRole.OWNER);
        map.put(DESIGN_ANY_PROJECT, ProjectRole.EDITOR);
        map.put(DEPLOY_ANY_PROJECT, ProjectRole.OWNER);
        map.put(VIEW_ANY_PROJECT, ProjectRole.VIEWER);
        map.put(DOCUMENT_ANY_PROJECT, ProjectRole.EDITOR);
        map.put(SOA_DESIGNER, ProjectRole.EDITOR);
        map.put(ADMIN_ANY_PROJECT, ProjectRole.OWNER);
        ROLE_MAPPING = Collections.unmodifiableMap(map);
    }
}

