/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.util.regex.Pattern;
import oracle.bpm.collections.Predicate;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdProjectUtil {
    private static final Predicate<PublicShareProject> ALL_PROJECTS = new Predicate<PublicShareProject>(){

        public boolean check(@Nullable PublicShareProject project) {
            boolean result = false;
            if (project != null) {
                result = project.isShared() || project.isOwner();
            }
            return result;
        }
    };
    private static final Predicate<PublicShareProject> MY_PROJECTS = new Predicate<PublicShareProject>(){

        public boolean check(@Nullable PublicShareProject project) {
            boolean result = false;
            if (project != null) {
                result = project.isManageable() && (project.isShared() || project.isOwner());
            }
            return result;
        }
    };
    private static final Predicate<PublicShareProject> SHARED_PROJECTS = new Predicate<PublicShareProject>(){

        public boolean check(@Nullable PublicShareProject project) {
            boolean result = false;
            if (project != null) {
                result = !project.isManageable() && (project.isShared() || project.isOwner());
            }
            return result;
        }
    };
    private static final Pattern SEPARATOR_MATCHER = Pattern.compile("\\/{2,}");
    private static final String SEPARATOR_REPLACEMENT = "\\/";

    public static String createMdProjectFullId(@NotNull ProjectType type, @NotNull MdProject project) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/MdProjectUtil.createMdProjectFullId must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/MdProjectUtil.createMdProjectFullId must not be null");
        }
        return MdProjectUtil.createMdProjectFullId(type, project.getId());
    }

    public static String createMdProjectFullId(@NotNull ProjectType type, @NotNull String path) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/MdProjectUtil.createMdProjectFullId must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/MdProjectUtil.createMdProjectFullId must not be null");
        }
        String projectPath = MetadataArtifactHelper.getRelativePathFrom(type);
        if ('/' != path.charAt(0)) {
            projectPath = projectPath + '/';
        }
        projectPath = projectPath + path;
        return SEPARATOR_MATCHER.matcher(projectPath).replaceAll(SEPARATOR_REPLACEMENT);
    }

    public static Predicate<PublicShareProject> getAllProjectsFilter() {
        return ALL_PROJECTS;
    }

    public static Predicate<PublicShareProject> getMyProjectsFilter() {
        return MY_PROJECTS;
    }

    public static Predicate<PublicShareProject> getSharedProjectsFilter() {
        return SHARED_PROJECTS;
    }
}

