/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.security;

import java.io.File;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MdDomainImpl;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.security.util.SecurityServiceFactory;
import oracle.bpm.pml.security.util.SecurityServiceHelper;
import oracle.bpm.pml.service.impl.BaseMetadataService;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.security.SecurityMdDomainDecorator;
import oracle.bpm.pml.service.security.SecurityRemoteService;
import oracle.bpm.pml.service.util.lookup.LookupService;
import oracle.bpm.pml.service.util.lookup.LookupServiceFactory;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

public abstract class MetadataSecurityAccessor
extends BaseMetadataService {
    protected PmlSecurityService securityService;

    public MetadataSecurityAccessor(@NotNull MDSInstance instance, @NotNull IRuntimeConfigService runtimeConfigService, @NotNull ApplicationType applicationType) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (runtimeConfigService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (applicationType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        super(instance, applicationType);
        LookupService lookupService = LookupServiceFactory.getLookupService();
        try {
            String serverURLFromFabricConfig = runtimeConfigService.getJndiURLFromFabricConfig();
            this.historyService = lookupService.lookupLocalHistoryService(serverURLFromFabricConfig);
        }
        catch (WorkflowException e) {
            throw new MetadataException(MetadataMsg.METADATA_EXCEPTION, (Throwable)e);
        }
        this.mdDomain = new MdDomainImpl(instance, this.historyService, applicationType);
        this.initLocalSecurityService(instance, runtimeConfigService, lookupService);
    }

    public MetadataSecurityAccessor(@NotNull MDSInstance instance, @NotNull ApplicationServerConnection applicationServerConnection, @NotNull ApplicationType applicationType, @NotNull LookupService lookupHelper) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (applicationType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (lookupHelper == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        super(instance, applicationServerConnection, applicationType, lookupHelper);
        this.initRemoteSecurityService(applicationServerConnection, lookupHelper);
    }

    public MetadataSecurityAccessor(@NotNull MDSInstance instance, @NotNull String persistenceUnit, @NotNull File jpsConfig, @NotNull String applicationName, @NotNull String userName, boolean clearJpsContext, @NotNull ApplicationType applicationType) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (persistenceUnit == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (jpsConfig == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        if (applicationType == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.<init> must not be null");
        }
        super(instance, persistenceUnit, applicationType);
        this.initFileBasedSecurityService(instance, jpsConfig, applicationName, userName, clearJpsContext);
    }

    private void initFileBasedSecurityService(@NotNull MDSInstance instance, @NotNull File jpsConfig, @NotNull String applicationName, @NotNull String userName, boolean clearJpsContext) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initFileBasedSecurityService must not be null");
        }
        if (jpsConfig == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initFileBasedSecurityService must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initFileBasedSecurityService must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initFileBasedSecurityService must not be null");
        }
        SecurityServiceHelper securityServiceHelper = SecurityServiceFactory.createSecurityHelper((File)jpsConfig, (String)applicationName, (boolean)clearJpsContext);
        this.securityService = SecurityServiceFactory.createPmlSecurityService((SecurityServiceHelper)securityServiceHelper, (String)userName);
        this.mdDomain = new SecurityMdDomainDecorator(this.mdDomain, this.securityService);
    }

    private void initRemoteSecurityService(@NotNull ApplicationServerConnection applicationServerConnection, @NotNull LookupService lookupHelper) throws MetadataException {
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initRemoteSecurityService must not be null");
        }
        if (lookupHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initRemoteSecurityService must not be null");
        }
        SecurityRemoteService remoteService = lookupHelper.lookupRemoteSecurityService(applicationServerConnection);
        remoteService.checkMigration();
        this.securityService = remoteService;
        this.mdDomain = new SecurityMdDomainDecorator(this.mdDomain, this.securityService);
    }

    private void initLocalSecurityService(@NotNull MDSInstance instance, @NotNull IRuntimeConfigService runtimeConfigService, LookupService lookupHelper) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initLocalSecurityService must not be null");
        }
        if (runtimeConfigService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/MetadataSecurityAccessor.initLocalSecurityService must not be null");
        }
        try {
            this.securityService = lookupHelper.lookupLocalSecurityService(runtimeConfigService.getJndiURLFromFabricConfig());
            this.mdDomain = new SecurityMdDomainDecorator(this.mdDomain, this.securityService);
            ((SecurityRemoteService)this.securityService).checkMigration();
        }
        catch (WorkflowException e) {
            throw new MetadataException((Throwable)e);
        }
    }
}

