/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ReferenceMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, EntryReference<K, V>> map = new HashMap<K, EntryReference<K, V>>();
    private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        V result = null;
        EntryReference<K, V> soft_ref = this.map.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.map.remove(key);
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V result = null;
        this.purge();
        EntryReference entryReference = this.map.put(key, new EntryReference(value, key, this.referenceQueue));
        if (entryReference != null) {
            result = (V)entryReference.get();
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = null;
        this.purge();
        EntryReference<K, V> entryReference = this.map.remove(key);
        if (entryReference != null) {
            result = (V)entryReference.get();
        }
        return result;
    }

    @Override
    public void clear() {
        this.purge();
        this.map.clear();
    }

    @Override
    public int size() {
        this.purge();
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private void purge() {
        EntryReference entryReference;
        while ((entryReference = (EntryReference)this.referenceQueue.poll()) != null) {
            this.map.remove(entryReference.key);
        }
    }

    private static class EntryReference<K, V>
    extends WeakReference<V> {
        private final K key;

        private EntryReference(V value, K key, ReferenceQueue<V> referenceQueue) {
            super(value, referenceQueue);
            this.key = key;
        }
    }
}

