/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.impl.PmlSecurityManagerServiceImpl;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.ProjectPolicies;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.service.MdProjectSecurityManagerService;
import oracle.bpm.pml.service.util.MdProjectUtil;
import org.jetbrains.annotations.NotNull;

public class MdProjectSecurityManagerServiceImpl
extends PmlSecurityManagerServiceImpl
implements MdProjectSecurityManagerService {
    public MdProjectSecurityManagerServiceImpl(@NotNull PmlSecurityService service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/MdProjectSecurityManagerServiceImpl.<init> must not be null");
        }
        super(service);
    }

    @Override
    public ProjectPolicies getProjectPolicies(@NotNull MdProject mdProject) throws PmlSecurityException {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/MdProjectSecurityManagerServiceImpl.getProjectPolicies must not be null");
        }
        ProjectType projectType = MetadataArtifactHelper.getProjectType(mdProject.getClass());
        String id = mdProject.getId();
        if (projectType == null && mdProject instanceof DraftProject) {
            projectType = ProjectType.PUBLIC_SHARED;
            id = ((DraftProject)mdProject).getPublicShareId();
        }
        String projectFullId = MdProjectUtil.createMdProjectFullId(projectType, id);
        return super.getProjectPolicies(projectFullId);
    }

    @Override
    public void saveProjectPolicies(@NotNull MdProject mdProject, final @NotNull ProjectPolicies policies) throws PmlSecurityException {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/MdProjectSecurityManagerServiceImpl.saveProjectPolicies must not be null");
        }
        if (policies == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/MdProjectSecurityManagerServiceImpl.saveProjectPolicies must not be null");
        }
        policies.save();
        Object securedProject = policies.getPolicy() == null ? new BasicSecuredProject(){

            public String getId() {
                return policies.getProjectName();
            }

            public boolean isEditable() {
                return false;
            }

            public boolean isManageable() {
                return false;
            }

            public boolean isOwner() {
                return false;
            }

            public boolean isShared() {
                return false;
            }
        } : policies.getPolicy().getSecuredProject();
        mdProject.setSecuredProject((BasicSecuredProject)securedProject);
    }
}

