/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpm.collections.Predicate;
import oracle.bpm.deployment.DbInfo;
import oracle.bpm.deployment.DeploymentResult;
import oracle.bpm.deployment.DeploymentService;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.MdTreeNode;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.PageContext;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.impl.MdDomainImpl;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.metadata.update.UpdateResult;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.service.ComposerMetadataService;
import oracle.bpm.pml.service.MdProjectSecurityManagerService;
import oracle.bpm.pml.service.impl.DeploymentPlanResult;
import oracle.bpm.pml.service.impl.MdProjectSecurityManagerServiceImpl;
import oracle.bpm.pml.service.security.AbstractRole;
import oracle.bpm.pml.service.security.MetadataSecurityAccessor;
import oracle.bpm.pml.service.security.SecurityContext;
import oracle.bpm.pml.service.util.DeployedProjectHelper;
import oracle.bpm.util.HashUtils;
import oracle.fabric.composite.CompositeDN;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerMetadataServiceImpl
extends MetadataSecurityAccessor
implements ComposerMetadataService {
    private DeployedProjectHelper deployedProjectHelper;
    private DeploymentService deploymentHelper;
    private SecurityContext securityContext;
    private MdProjectSecurityManagerService securityManagerService;
    private MdDomain soainfraMdDomain;

    public ComposerMetadataServiceImpl(@NotNull MDSInstance composerMdsInstance, @NotNull String userName, @NotNull IRuntimeConfigService runtimeConfigService, @Nullable DeploymentService deploymentHelper, @Nullable MDSInstance soainfraMdsInstance) throws MetadataException {
        if (composerMdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (runtimeConfigService == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        super(composerMdsInstance, runtimeConfigService, ApplicationType.COMPOSER);
        this.deployedProjectHelper = null;
        this.securityManagerService = new MdProjectSecurityManagerServiceImpl(this.securityService);
        if (soainfraMdsInstance != null) {
            this.soainfraMdDomain = new MdDomainImpl(soainfraMdsInstance, this.historyService, ApplicationType.COMPOSER);
            this.deployedProjectHelper = new DeployedProjectHelper(this.soainfraMdDomain, soainfraMdsInstance);
        }
        this.deploymentHelper = deploymentHelper;
        PmlPrincipal principal = this.securityService.getPrincipal();
        EnumSet<AbstractRole> role = principal.isGlobalOwner() ? EnumSet.of(AbstractRole.ADMIN_ANY_PROJECT) : (principal.isSoaEditor() ? EnumSet.of(AbstractRole.SOA_DESIGNER) : EnumSet.noneOf(AbstractRole.class));
        this.securityContext = new SecurityContext(userName, role);
    }

    public ComposerMetadataServiceImpl(@NotNull MDSInstance composerMdsInstance, @Nullable DeploymentService deploymentHelper, @Nullable MDSInstance soainfraMdsInstance, @NotNull String persistenceUnit, @NotNull File jpsConfig, @NotNull String applicationName, @NotNull String username, boolean cleanJpsContext) throws MetadataException {
        if (composerMdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (persistenceUnit == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (jpsConfig == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        super(composerMdsInstance, persistenceUnit, jpsConfig, applicationName, username, cleanJpsContext, ApplicationType.COMPOSER);
        this.deployedProjectHelper = null;
        this.securityManagerService = new MdProjectSecurityManagerServiceImpl(this.securityService);
        if (soainfraMdsInstance != null) {
            this.soainfraMdDomain = new MdDomainImpl(soainfraMdsInstance, this.historyService, ApplicationType.COMPOSER);
            this.deployedProjectHelper = new DeployedProjectHelper(this.soainfraMdDomain, soainfraMdsInstance);
        }
        this.deploymentHelper = deploymentHelper;
        this.securityContext = new SecurityContext(username);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public MdTree browsePartitions(@Nullable Predicate<String> predicate) throws MetadataException {
        return this.soainfraMdDomain.browseFolders(DeployedProject.class, predicate);
    }

    @Override
    public <K extends MdProject> MdTree browse(@NotNull Class<K> type, Predicate<K> predicate) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.browse must not be null");
        }
        return this.mdDomain.browseProject(type, predicate, null);
    }

    @Override
    public <T extends MdProject> ProjectFolder findProjectByName(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.findProjectByName must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.findProjectByName must not be null");
        }
        return this.mdDomain.findProjectByName(type, projectName);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> type, @NotNull String projectFolder, boolean reload) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProject must not be null");
        }
        if (projectFolder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProject must not be null");
        }
        if (reload) {
            this.mdDomain.releaseFromCache(type, projectFolder);
        }
        return this.mdDomain.loadProject(type, projectFolder, false);
    }

    @Override
    public LocalRef<DraftProject> loadDraft(@NotNull String projectName, boolean reload) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadDraft must not be null");
        }
        if (reload) {
            String draftLocation = projectName + "/" + HashUtils.generateMd5(this.securityContext.getPrincipal());
            this.mdDomain.releaseFromCache(DraftProject.class, draftLocation);
        }
        return this.mdDomain.loadDraftProject(projectName, this.securityContext.getPrincipal());
    }

    @Override
    public LocalRef<ProjectToDeploy> loadProjectPendingForDeploy(@NotNull String projectName, @NotNull String workflowTicket) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProjectPendingForDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProjectPendingForDeploy must not be null");
        }
        StringBuilder id = new StringBuilder("/");
        id.append(projectName).append("/").append(workflowTicket);
        return this.mdDomain.loadProject(ProjectToDeploy.class, id.toString(), false);
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull TemplateProject templateProject, boolean overwrite, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        if (!overwrite && this.mdDomain.existsProject(PublicShareProject.class, ProjectFolder.create(location, publicShareProject.getName()))) {
            throw MetadataExceptionFactory.createProjectAlreadyExists((String)publicShareProject.getId());
        }
        return this.mdDomain.createPublicShare(location, publicShareProject, templateProject, this.securityService.getUserName(), false, keepLock);
    }

    @Override
    public PublicShareProject savePublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, boolean overwrite, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.savePublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.savePublicShare must not be null");
        }
        if (!overwrite && this.mdDomain.existsProject(PublicShareProject.class, location)) {
            throw MetadataExceptionFactory.createProjectAlreadyExists((String)publicShareProject.getId());
        }
        return this.mdDomain.savePublicShare(location, publicShareProject, this.securityService.getUserName(), false, keepLock);
    }

    @Override
    public DraftProject createDraft(@NotNull PublicShareProject project) throws MetadataException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createDraft must not be null");
        }
        return this.mdDomain.getLock(project, this.securityContext.getPrincipal());
    }

    @Override
    public void releaseDraft(@NotNull DraftProject draft) throws MetadataException {
        if (draft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseDraft must not be null");
        }
        this.mdDomain.releaseLock(draft.getFolder().get().getLocation());
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseLock must not be null");
        }
        this.mdDomain.releaseLock(publicShare);
    }

    @Override
    public void deletePublicShare(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePublicShare must not be null");
        }
        if (!this.listSnapshots(publicShareProject.getId()).isEmpty()) {
            this.mdDomain.deleteAllSnapshotsFromPublicShare(publicShareProject.getId());
        }
        this.mdDomain.removePublicShare(publicShareProject);
    }

    @Override
    public MdTree getPublicSharesLinkedToTemplate(@NotNull TemplateProject template) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getPublicSharesLinkedToTemplate must not be null");
        }
        return this.mdDomain.getPublicSharesLinkedToTemplate(template);
    }

    @Override
    public void deleteTemplate(@NotNull TemplateProject templateProject, boolean breakLinks) throws MetadataException {
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteTemplate must not be null");
        }
        this.mdDomain.removeTemplate(templateProject, breakLinks);
    }

    @Override
    public void updateDraft(@NotNull DraftProject draftProject) throws MetadataException {
        if (draftProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updateDraft must not be null");
        }
        this.mdDomain.updateDraft(draftProject);
    }

    @Override
    public void commitDraft(@NotNull DraftProject draft) throws MetadataException {
        if (draft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.commitDraft must not be null");
        }
        this.mdDomain.commitChanges(draft.getFolder().get().getLocation(), this.securityService.getUserName());
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createFolder must not be null");
        }
        this.mdDomain.createFolder(type, folder);
    }

    @Override
    public <T extends MdProject> void deleteFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteFolder must not be null");
        }
        this.mdDomain.removeFolder(type, folder, recursive);
    }

    @Override
    public void releaseProjectPendingForDeploy(@NotNull ProjectToDeploy projectToDeploy) throws MetadataException {
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseProjectPendingForDeploy must not be null");
        }
        this.mdDomain.removeProject(ProjectToDeploy.class, projectToDeploy);
    }

    @Override
    public MdTree getProjectsPendingForDeploy(@Nullable Predicate<ProjectToDeploy> predicate) throws MetadataException {
        return this.mdDomain.browseProject(ProjectToDeploy.class, predicate, null);
    }

    @Override
    public DeploymentResult createPartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) throws MetadataException {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPartition must not be null");
        }
        DeploymentResult result = null;
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        if (result == null) {
            result = this.deploymentHelper.createPartition(serverURL, user, password, partition);
        }
        return result;
    }

    @Override
    public DeploymentResult deletePartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) throws MetadataException {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePartition must not be null");
        }
        DeploymentResult result = null;
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        if (result == null) {
            result = this.deploymentHelper.deletePartition(serverURL, user, password, partition);
        }
        return result;
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.prepareProjectToDeploy must not be null");
        }
        this.mdDomain.prepareProjectToDeploy(publicShare, workflowTicket);
    }

    @Override
    public DeploymentResult deployProject(@NotNull URL host, @NotNull String username, @NotNull String password, boolean overwrite, boolean useDefaultVersion, @Nullable File deploymetPlan, @NotNull ProjectToDeploy project, @Nullable String partition, @Nullable DbInfo dbInfo) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.deploy(host, username, password, project, project.getVersion(), overwrite, useDefaultVersion, deploymetPlan, null, partition, dbInfo);
    }

    @Override
    public DeploymentResult generateSarFile(@NotNull MdProject project, @NotNull String version, @Nullable DbInfo dbInfo) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.generateSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.generateSarFile must not be null");
        }
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.generateSarFile(project, version, dbInfo);
    }

    @Override
    public DeploymentPlanResult generateDeploymentPlan(@NotNull MdProject mdProject) throws MetadataException {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.generateDeploymentPlan must not be null");
        }
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentPlanResult(new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey()), null);
        }
        return this.deploymentHelper.generateDeploymentPlan(mdProject);
    }

    @Override
    public InputStream getSarFile(@NotNull MdProject project, @NotNull String version) throws MetadataException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSarFile must not be null");
        }
        File sarFile = this.deploymentHelper.getSarFile(project, version);
        try {
            return new BufferedInputStream(new FileInputStream(sarFile));
        }
        catch (FileNotFoundException e) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_FAILED, (Throwable)e);
        }
    }

    @Override
    public Collection<LocalRef<DeployedProject>> getDeployedProjects() throws MetadataException {
        if (this.deployedProjectHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
        return this.deployedProjectHelper.getDeployedProjects(null);
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull CompositeDN compositeDN) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getDeployedProject must not be null");
        }
        if (this.deployedProjectHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
        return this.deployedProjectHelper.getDeployedProject(compositeDN);
    }

    @Override
    public Collection<LocalRef<DeployedProject>> getDeployedProjects(@Nullable ComposerMetadataService.DeployedProjectFilter filter) throws MetadataException {
        if (this.deployedProjectHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
        return this.deployedProjectHelper.getDeployedProjects(filter);
    }

    @Override
    public void updatePublicShareProperties(@NotNull String publicShareId, boolean allowSharing, @Nullable String workflow, @Nullable List<String> participantIds) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updatePublicShareProperties must not be null");
        }
        LocalRef<PublicShareProject> projectLocalRef = this.mdDomain.loadProject(PublicShareProject.class, publicShareId, false);
        PublicShareProject project = projectLocalRef.get();
        this.mdDomain.updatePublicShareProperties(publicShareId, allowSharing, workflow, participantIds);
    }

    @Override
    public String getLastDeployedVersion(@NotNull String projectName) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getLastDeployedVersion must not be null");
        }
        return this.deployedProjectHelper.getLastDeployedVersion(projectName);
    }

    @Override
    public void importTemplate(@NotNull File folder, @NotNull ProjectFolder destination, @NotNull String projectName, @Nullable String description) throws MetadataException {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importTemplate must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importTemplate must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importTemplate must not be null");
        }
        this.mdDomain.importProject(folder, TemplateProject.class, destination, this.securityService.getUserName(), projectName, description);
    }

    @Override
    public void importPublicShare(@NotNull File folder, @NotNull ProjectFolder destination, @NotNull String projectName, @Nullable String description) throws MetadataException {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importPublicShare must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importPublicShare must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.importPublicShare must not be null");
        }
        this.mdDomain.importProject(folder, PublicShareProject.class, destination, this.securityService.getUserName(), projectName, description);
    }

    @Override
    public List<Change> listHistoryChanges(@NotNull Criteria criteria, @Nullable PageContext pageContext) throws MetadataException {
        if (criteria == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.listHistoryChanges must not be null");
        }
        return this.historyService.listHistoryChanges(criteria, pageContext);
    }

    @Override
    public List<ChangedItem> getRecentlyChangedItems(@NotNull String projectName, int qty) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getRecentlyChangedItems must not be null");
        }
        return this.historyService.getRecentlyChangedItems(projectName, qty);
    }

    @Override
    public void updateProperties(@NotNull String projectLocation, @NotNull HashMap<String, String> properties) throws MetadataException {
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updateProperties must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updateProperties must not be null");
        }
        this.mdDomain.updateProperties(PublicShareProject.class, projectLocation, properties);
    }

    @Override
    public void createSnapshot(@NotNull PublicShareProject publicShareProject, @NotNull String versionName, @Nullable String description) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createSnapshot must not be null");
        }
        this.mdDomain.createSnapshot(publicShareProject, versionName, description, this.securityService.getUserName());
    }

    @Override
    public List<LocalRef<SnapshotProject>> listSnapshots(@NotNull String publicshareId) throws MetadataException {
        if (publicshareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.listSnapshots must not be null");
        }
        return this.mdDomain.listSnapshots(publicshareId);
    }

    @Override
    public void deleteSnapshot(@NotNull String snapshotId) throws MetadataException {
        if (snapshotId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteSnapshot must not be null");
        }
        this.mdDomain.deleteSnapshot(snapshotId);
    }

    @Override
    public LocalRef<SnapshotProject> getSnapshot(@NotNull String publicShareId, @NotNull String versionName) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSnapshot must not be null");
        }
        return this.mdDomain.getSnapshot(publicShareId, versionName);
    }

    @Override
    public DeploymentResult deploySnapshot(@NotNull URL host, @NotNull String username, @NotNull String password, boolean overwrite, boolean useDefaultVersion, @NotNull SnapshotProject project, @Nullable String partition, @Nullable DbInfo dbInfo, @NotNull String version, @Nullable File deploymentPlan) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deploySnapshot must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deploySnapshot must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deploySnapshot must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deploySnapshot must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deploySnapshot must not be null");
        }
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.deploy(host, username, password, project, version, overwrite, useDefaultVersion, deploymentPlan, null, partition, dbInfo);
    }

    @Override
    public UpdateResult calculateFilesToBeUpdated(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.calculateFilesToBeUpdated must not be null");
        }
        return this.mdDomain.calculateFilesToBeUpdated(publicShare);
    }

    @Override
    public UpdateResult updatePublicShareFromBaseTemplate(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updatePublicShareFromBaseTemplate must not be null");
        }
        return this.mdDomain.updatePublicShareFromBaseTemplate(publicShare, this.securityService.getUserName());
    }

    @Override
    public MdProjectSecurityManagerService getSecurityManagerService() {
        return this.securityManagerService;
    }

    @Override
    public DeploymentResult deployDraft(@NotNull URL host, @NotNull String username, @NotNull String password, boolean overwrite, boolean useDefaultVersion, @NotNull DraftProject project, @NotNull String partition, @Nullable DbInfo dbInfo, @NotNull String version, @Nullable File deploymentPlan) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployDraft must not be null");
        }
        try {
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        try {
            List<MdTreeNode<ProjectArtifact>> p = this.browsePartitions(null).getRootNode().getChildren();
            boolean partitionExist = false;
            for (MdTreeNode<ProjectArtifact> aP : p) {
                ProjectFolder folder = (ProjectFolder)aP.getObject();
                if (!folder.getLocation().equals("/" + partition)) continue;
                partitionExist = true;
                break;
            }
            if (!partitionExist) {
                this.createPartition(host, username, password, partition);
            }
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.deploy(host, username, password, project, version, overwrite, useDefaultVersion, deploymentPlan, null, partition, dbInfo);
    }

    private void checkDeploymentHelper() throws MetadataException {
        if (this.deploymentHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
    }
}

