/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.util.ant;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskInvoker {
    private static final String ANT_FILE = "ant.file";
    private static final String BASE_DIR = "baseDir";
    private static final String ANT_PROJECT_HELPER = "ant.projectHelper";

    public static void doInvoke(@NotNull File antFile, @NotNull String targetName, @Nullable Map<String, String> properties) throws Exception {
        if (antFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.doInvoke must not be null");
        }
        if (targetName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.doInvoke must not be null");
        }
        TaskInvoker.invokeProject(TaskInvoker.buildProject(antFile, properties), targetName);
    }

    public static Object[] buildProject(@NotNull File antFile, @Nullable Map<String, String> properties) throws Exception {
        if (antFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.buildProject must not be null");
        }
        Project project = new Project();
        String baseDir = properties.containsKey(BASE_DIR) ? properties.get(BASE_DIR) : antFile.getParentFile().getAbsolutePath();
        project.setBasedir(baseDir);
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DefaultLogger listener = new DefaultLogger();
            listener.setMessageOutputLevel(3);
            listener.setErrorPrintStream(new PrintStream(new BufferedOutputStream(errorStream)));
            listener.setOutputPrintStream(new PrintStream(new BufferedOutputStream(outputStream)));
            project.setProjectReference((Object)listener);
            project.addBuildListener((BuildListener)listener);
            project.fireBuildStarted();
            project.init();
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    if (entry.getKey().equals(BASE_DIR)) continue;
                    project.setProperty(entry.getKey(), entry.getValue());
                }
            }
            project.setUserProperty(ANT_FILE, antFile.getAbsolutePath());
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            project.addReference(ANT_PROJECT_HELPER, (Object)helper);
            helper.parse(project, (Object)antFile);
        }
        catch (BuildException e) {
            project.fireBuildFinished((Throwable)e);
            throw new Exception(errorStream.toString(), e);
        }
        return new Object[]{project, errorStream, outputStream};
    }

    public static void invokeProject(@NotNull Object[] objects, @NotNull String targetName) throws Exception {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.invokeProject must not be null");
        }
        if (targetName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.invokeProject must not be null");
        }
        Project p = (Project)objects[0];
        ByteArrayOutputStream errorStream = (ByteArrayOutputStream)objects[1];
        try {
            p.executeTarget(targetName);
            p.fireBuildFinished(null);
        }
        catch (BuildException e) {
            p.fireBuildFinished((Throwable)e);
            throw new Exception(errorStream.toString(), e);
        }
    }

    public static Set<String> getTargets(@NotNull Object[] objects) throws Exception {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/ant/TaskInvoker.getTargets must not be null");
        }
        Project project = (Project)objects[0];
        ByteArrayOutputStream errorStream = (ByteArrayOutputStream)objects[1];
        try {
            return new TreeSet<String>(project.getTargets().keySet());
        }
        catch (BuildException e) {
            project.fireBuildFinished((Throwable)e);
            throw new Exception(errorStream.toString(), e);
        }
    }
}

