/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.util;

import java.io.IOException;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.mds.utils.ProjectArtifactHelper;
import org.jetbrains.annotations.NotNull;

final class AdfConfigFileWriter {
    private static String ADF_DB_TEMPLATE_CONTENT = "<?xml version=\"1.0\" encoding=\"US-ASCII\" ?>\n<adf-config xmlns=\"http://xmlns.oracle.com/adf/config\"\n            xmlns:adf=\"http://xmlns.oracle.com/adf/config/properties\"\n            xmlns:sec=\"http://xmlns.oracle.com/adf/security/config\">\n  <adf:adf-properties-child xmlns=\"http://xmlns.oracle.com/adf/config/properties\">\n    <adf-property name=\"adfAppUID\" value=\"BPMAGApp3-7728\"/>\n  </adf:adf-properties-child>\n  <adf-mds-config xmlns=\"http://xmlns.oracle.com/adf/mds/config\">\n    <mds-config xmlns=\"http://xmlns.oracle.com/mds/config\">\n      <persistence-config>\n        <metadata-namespaces>\n\t\t\t<namespace path=\"/soa/b2b\" metadata-store-usage=\"soa-infra-store\"/>\n\t\t\t<namespace path=\"/deployed-composites\" metadata-store-usage=\"soa-infra-store\"/>\n\t\t\t<namespace path=\"/soa/shared\" metadata-store-usage=\"soa-infra-store\"/>\n\t\t\t<namespace path=\"/soa/configuration\" metadata-store-usage=\"soa-infra-store\"/>\n\t\t\t<namespace path=\"/apps\" metadata-store-usage=\"soa-infra-store\"/>\n\t\t\t<namespace path=\"/shared-libs\" metadata-store-usage=\"soa-infra-store\"/>\n        </metadata-namespaces>\n        <metadata-store-usages>\n          <metadata-store-usage id=\"soa-infra-store\">\n            <metadata-store class-name=\"oracle.mds.persistence.stores.db.DBMetadataStore\">\n              <property name=\"jdbc-userid\" value=\"%USERNAME\"/>\n              <property name=\"jdbc-password\" value=\"%PASSWORD\"/>\n              <property name=\"jdbc-url\" value=\"jdbc:oracle:thin:@%HOST:%PORT:%SID\"/>\n              <property value=\"%PARTITION_NAME\" name=\"partition-name\"/>\n            </metadata-store>\n          </metadata-store-usage>\n        </metadata-store-usages>\n      </persistence-config>\n    </mds-config>\n  </adf-mds-config>\n</adf-config>";
    private static String ADF_LOCAL_TEMPLATE_CONTENT = "<?xml version=\"1.0\" encoding=\"US-ASCII\" ?>\n<adf-config xmlns=\"http://xmlns.oracle.com/adf/config\"\n            xmlns:adf=\"http://xmlns.oracle.com/adf/config/properties\"\n            xmlns:sec=\"http://xmlns.oracle.com/adf/security/config\">\n  <adf:adf-properties-child xmlns=\"http://xmlns.oracle.com/adf/config/properties\">\n    <adf-property name=\"adfAppUID\" value=\"BPMAGApp3-7728\"/>\n  </adf:adf-properties-child>\n  <adf-mds-config xmlns=\"http://xmlns.oracle.com/adf/mds/config\">\n    <mds-config xmlns=\"http://xmlns.oracle.com/mds/config\">\n      <persistence-config>\n        <metadata-namespaces>\n          <namespace metadata-store-usage=\"mstore-usage_1\" path=\"%NAMESPACE\"/>\n        </metadata-namespaces>\n        <metadata-store-usages>\n          <metadata-store-usage id=\"mstore-usage_1\">\n            <metadata-store class-name=\"oracle.mds.persistence.stores.file.FileMetadataStore\">\n              <property value=\"%PATH\"\n                        name=\"metadata-path\"/>\n              <property value=\"%PARTITION_NAME\" name=\"partition-name\"/>\n            </metadata-store>\n          </metadata-store-usage>\n        </metadata-store-usages>\n      </persistence-config>\n    </mds-config>\n  </adf-mds-config>\n</adf-config>";

    AdfConfigFileWriter() {
    }

    public static void writeBaseOnFsMds(@NotNull VFile targetFolder, @NotNull String namespace, @NotNull String partitionName, @NotNull String soaPath) throws IOException {
        if (targetFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnFsMds must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnFsMds must not be null");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnFsMds must not be null");
        }
        if (soaPath == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnFsMds must not be null");
        }
        VFile adfConfigFile = targetFolder.getFileSystem().createFile(targetFolder, "adf-config.xml");
        String content = Str.replace((String)ADF_LOCAL_TEMPLATE_CONTENT, (String)"%NAMESPACE", (String)namespace);
        content = Str.replace((String)content, (String)"%PATH", (String)soaPath);
        content = Str.replace((String)content, (String)"%PARTITION_NAME", (String)partitionName);
        ProjectArtifactHelper.saveVFile(adfConfigFile, content);
    }

    public static void writeBaseOnDbMds(@NotNull VFile targetFolder, @NotNull String partitionName, @NotNull String host, @NotNull String port, @NotNull String sid, @NotNull String username, @NotNull String password) throws IOException {
        if (targetFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (partitionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (port == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (sid == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/deployment/util/AdfConfigFileWriter.writeBaseOnDbMds must not be null");
        }
        VFile adfConfigFile = targetFolder.getFileSystem().createFile(targetFolder, "adf-config.xml");
        String content = Str.replace((String)ADF_DB_TEMPLATE_CONTENT, (String)"%PARTITION_NAME", (String)partitionName);
        content = Str.replace((String)content, (String)"%HOST", (String)host);
        content = Str.replace((String)content, (String)"%PORT", (String)port);
        content = Str.replace((String)content, (String)"%SID", (String)sid);
        content = Str.replace((String)content, (String)"%USERNAME", (String)username);
        content = Str.replace((String)content, (String)"%PASSWORD", (String)password);
        ProjectArtifactHelper.saveVFile(adfConfigFile, content);
    }
}

