/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment;

import java.io.File;
import java.net.URL;
import oracle.bpm.deployment.DeploymentService;
import oracle.bpm.deployment.impl.AntDeploymentService;
import oracle.bpm.deployment.impl.ScacDeploymentService;
import oracle.bpm.deployment.util.DeploymentServiceUtils;
import org.jetbrains.annotations.NotNull;

public final class DeploymentServiceFactory {
    private DeploymentServiceFactory() {
    }

    public static DeploymentService create(@NotNull File tmpDirectory, @NotNull File antScaDirectory, @NotNull File antDirectory, @NotNull URL soaSharedBundle) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentServiceFactory.create must not be null");
        }
        if (antScaDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/DeploymentServiceFactory.create must not be null");
        }
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/DeploymentServiceFactory.create must not be null");
        }
        if (soaSharedBundle == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/DeploymentServiceFactory.create must not be null");
        }
        DeploymentService result = DeploymentServiceUtils.isAntTaskValidatorPresent() ? new AntDeploymentService(tmpDirectory, antScaDirectory, antDirectory, soaSharedBundle) : new ScacDeploymentService(tmpDirectory, antScaDirectory, antDirectory);
        return result;
    }
}

