/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.bpm.deployment.DeploymentFault;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeploymentResult {
    private Msg errorMsg;
    private List<DeploymentFault> faults;
    private boolean foundError;
    private DeploymentFaultType mainType;
    private static final QName FAULT_TAG = new QName("Fault");

    public DeploymentResult() {
        this(DeploymentFaultType.NO_FAULT);
    }

    public DeploymentResult(@NotNull DeploymentFaultType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.<init> must not be null");
        }
        this(type, null);
    }

    public DeploymentResult(@NotNull DeploymentFaultType type, @Nullable Msg msg) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.<init> must not be null");
        }
        this.faults = new ArrayList<DeploymentFault>();
        this.mainType = type;
        this.errorMsg = msg == null ? this.mainType.getDefaultMsg() : msg;
        this.foundError = !DeploymentFaultType.NO_FAULT.equals((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentResult parseCompileOutput(@NotNull File file, @Nullable Msg msg) {
        InputStream is;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.parseCompileOutput must not be null");
        }
        DeploymentResult result = new DeploymentResult(DeploymentFaultType.VALIDATION, msg);
        try {
            URL doc = file.toURI().toURL();
            is = doc.openStream();
        }
        catch (IOException e) {
            is = null;
        }
        if (is != null) {
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLStreamReader sr = inputFactory.createXMLStreamReader(is);
                while (sr.hasNext()) {
                    DeploymentFault fault;
                    QName srName;
                    int eventCode = sr.next();
                    if (eventCode != 1 || !FAULT_TAG.equals(srName = sr.getName()) || (fault = DeploymentResult.parseFault(sr)) == null) continue;
                    result.addFault(fault);
                }
                sr.close();
            }
            catch (XMLStreamException e) {
                try {
                    result.faults.clear();
                }
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                StreamUtils.close((Closeable[])new Closeable[]{is});
            }
            StreamUtils.close((Closeable[])new Closeable[]{is});
        }
        if (!result.hasFaults()) {
            result = new DeploymentResult();
        }
        return result;
    }

    public boolean hasFaults() {
        return !this.faults.isEmpty();
    }

    public boolean isSuccessful() {
        return !this.foundError;
    }

    public Msg getErrorMsg() {
        return this.errorMsg;
    }

    public ListIterator<DeploymentFault> getFaultList() {
        return Collections.unmodifiableList(this.faults).listIterator();
    }

    public void addFault(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.addFault must not be null");
        }
        this.addFault(new DeploymentFault(e));
    }

    public void addFault(@NotNull DeploymentFault fault) {
        if (fault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.addFault must not be null");
        }
        if (!(DeploymentFaultType.NO_FAULT.equals((Object)this.mainType) || this.foundError && this.hasFaults())) {
            this.foundError = fault.shouldFail();
        }
        this.faults.add(fault);
    }

    public boolean isConfigurationType() {
        return this.mainType == DeploymentFaultType.CONFIGURATION;
    }

    public boolean isValidationType() {
        return this.mainType == DeploymentFaultType.VALIDATION;
    }

    public boolean isDeploymentType() {
        return this.mainType == DeploymentFaultType.DEPLOYMENT;
    }

    public String toString() {
        String result = "\n=== DeploymentResult ====================================================\n";
        result = result + String.format("Type: %s\nMSG: %s\n", new Object[]{this.mainType, this.getErrorMsg()});
        int i = 1;
        ListIterator<DeploymentFault> faults = this.getFaultList();
        while (faults.hasNext()) {
            DeploymentFault fault = faults.next();
            result = result + i++ + ".- " + fault;
        }
        result = result + "=== DeploymentResult End ================================================\n";
        return result;
    }

    private static DeploymentFault parseFault(@NotNull XMLStreamReader sr) throws XMLStreamException {
        if (sr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult.parseFault must not be null");
        }
        DeploymentFault result = null;
        DeploymentFault.FaultTag currentFault = null;
        boolean endTag = false;
        while (sr.hasNext() && !endTag) {
            switch (sr.next()) {
                case 1: {
                    currentFault = DeploymentFault.FaultTag.valueOfId(sr.getName());
                    break;
                }
                case 4: {
                    if (sr.isWhiteSpace() || currentFault == null) break;
                    if (result == null) {
                        result = new DeploymentFault();
                    }
                    result.setFaultValue(currentFault, sr.getText().toUpperCase());
                    break;
                }
                case 2: {
                    currentFault = null;
                    if (!FAULT_TAG.equals(sr.getName())) break;
                    endTag = true;
                }
            }
        }
        return result;
    }

    public static enum DeploymentFaultType {
        CONFIGURATION((Msg)MetadataMsg.DEPLOYMENT_CONFIGURATION),
        VALIDATION((Msg)MetadataMsg.DEPLOYMENT_VALIDATION_ERROR),
        DEPLOYMENT((Msg)MetadataMsg.DEPLOYMENT_FAILED),
        NO_FAULT(Msg.QUOTE((String)"No error message available"));

        private Msg defaultMsg;

        private DeploymentFaultType(Msg msg) {
            if (string == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentResult$DeploymentFaultType.<init> must not be null");
            }
            this.defaultMsg = msg;
        }

        public Msg getDefaultMsg() {
            return this.defaultMsg;
        }
    }
}

