/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.impl;

import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.TranslatableType;
import oracle.bpm.common.model.impl.EntityImpl;

public class TranslatableImpl
extends EntityImpl
implements Translatable,
Translatable.Resource {
    private static final long serialVersionUID = 6419045470277316425L;

    public TranslatableImpl() {
        this.setTranslatableType(TranslatableType.STATIC);
        this.setParams(CommonFactory.createParams());
    }

    @Override
    public String getValue() {
        return this.getAttr(Translatable.Metadata.VALUE);
    }

    @Override
    public void setValue(String value) {
        this.setAttr(Translatable.Metadata.VALUE, value);
    }

    @Override
    public TranslatableType getTranslatableType() {
        return this.getAttr(Translatable.Metadata.TYPE);
    }

    @Override
    public Translatable.Params getParams() {
        return this.getAttr(Translatable.Resource.Metadata.PARAMS);
    }

    @Override
    public void setParams(Translatable.Params value) {
        this.setAttr(Translatable.Resource.Metadata.PARAMS, value);
    }

    @Override
    public Translatable toStatic() {
        if (!this.getTranslatableType().isStatic()) {
            this.changeTo(TranslatableType.STATIC);
        }
        return this;
    }

    @Override
    public Translatable.Resource toResource() {
        if (!this.getTranslatableType().isResource()) {
            this.changeTo(TranslatableType.RESOURCE);
        }
        return this;
    }

    private void setTranslatableType(TranslatableType type) {
        this.setAttr(Translatable.Metadata.TYPE, type);
    }

    private void changeTo(TranslatableType type) {
        this.setValue(null);
        this.getParams().clear();
        this.setTranslatableType(type);
    }
}

