/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.impl.MapEntityImpl;
import org.jetbrains.annotations.NotNull;

public class PropertyBundlesImpl
extends MapEntityImpl<Locale, PropertyBundle>
implements PropertyBundles {
    private static final Locale[] LOCALES = new Locale[]{Locale.ENGLISH, new Locale("ar"), new Locale("cs"), new Locale("da"), Locale.GERMAN, new Locale("el"), new Locale("es"), new Locale("fi"), Locale.FRENCH, new Locale("hu"), Locale.ITALIAN, new Locale("iw"), Locale.JAPANESE, Locale.KOREAN, new Locale("nl"), new Locale("no"), new Locale("pl"), new Locale("pl", "BR"), new Locale("pt"), new Locale("ro"), new Locale("ru"), new Locale("sk"), new Locale("sv"), new Locale("th"), new Locale("tr"), Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
    private static final long serialVersionUID = -1329886547585299811L;

    public PropertyBundlesImpl(@NotNull String name) {
        this.setName(name);
        this.setDefault(CommonFactory.createDefaultPropertyBundle());
    }

    @Override
    public String getName() {
        return this.getAttr(PropertyBundles.Metadata.NAME);
    }

    @Override
    public String getName(Locale locale) {
        return locale == null ? this.getName() : this.getName() + "_" + locale.toString();
    }

    @Override
    public void setDefault(@NotNull PropertyBundle value) {
        this.setAttr(PropertyBundles.Metadata.DEFAULT, value);
    }

    @Override
    @NotNull
    public PropertyBundle getDefault() {
        return this.getAttr(PropertyBundles.Metadata.DEFAULT);
    }

    @Override
    public List<Locale> getLocales() {
        Set<Locale> localeSet = this.getAttr(PropertyBundles.Metadata.BUNDLES).keySet();
        ArrayList<Locale> localeList = new ArrayList<Locale>(localeSet);
        Collections.sort(localeList, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return Collections.unmodifiableList(localeList);
    }

    @Override
    public List<Locale> getAvailableLocales() {
        ArrayList<Locale> result = new ArrayList<Locale>();
        List<Locale> locales = this.getLocales();
        for (Locale locale : LOCALES) {
            if (locales.contains(locale)) continue;
            result.add(locale);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    protected Map<Locale, PropertyBundle> getMap() {
        return this.getAttr(PropertyBundles.Metadata.BUNDLES);
    }

    private void setName(String name) {
        this.setAttr(PropertyBundles.Metadata.NAME, name);
    }
}

