/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.cm.impl;

import java.util.Collections;
import java.util.List;
import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Category;
import oracle.bpm.casemgmt.model.cm.EcmFolder;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.model.cm.NamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.Outcomes;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.common.model.impl.EntityImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseImpl
extends EntityImpl
implements Case {
    private static final long serialVersionUID = -4317840446272707170L;
    private static final int DEFAULT_PRIORITY = 3;

    public CaseImpl(@NotNull String name) {
        this.setName(name);
        this.setPriority(3);
        this.setTitle(CaseFactory.createTitle().toStatic());
        this.setCategory(CaseFactory.createCategory());
        this.setResourceBundle(name + "ResourceBundle");
        PropertyBundles propertyBundles = CommonFactory.createPropertyBundles(this.getResourceBundle());
        PropertyBundle bundle = propertyBundles.getDefault();
        bundle.put(name, name);
        bundle.put("PUBLIC", "Public");
        bundle.put("RESTRICTED", "Restricted");
        this.setPropertyBundles(propertyBundles);
        Permissions permissions = CaseFactory.createPermissions();
        permissions.add("PUBLIC");
        permissions.add("RESTRICTED");
        this.setPermissions(permissions);
        this.setMilestones(CaseFactory.createMilestones());
        this.setEvents(CaseFactory.createEvents());
        this.setOutcomes(CaseFactory.createOutcomes());
        this.setStakeHolders(CaseFactory.createStakeHolders());
        this.setEcmFolder(CaseFactory.createEcmFolder());
        this.setNamespacePrefixes(CaseFactory.createNamespacePrefixes());
    }

    @Override
    public void setTargetNamespace(String value) {
        this.setAttr(Case.Metadata.TARGET_NAMESPACE, value);
    }

    @Override
    public String getTargetNamespace() {
        return this.getAttr(Case.Metadata.TARGET_NAMESPACE);
    }

    @Override
    public void setId(String value) {
        this.setAttr(Case.Metadata.ID, value);
    }

    @Override
    public String getId() {
        return this.getAttr(Case.Metadata.ID);
    }

    @Override
    public void setName(String value) {
        this.setAttr(Case.Metadata.NAME, value);
    }

    @Override
    public String getName() {
        return this.getAttr(Case.Metadata.NAME);
    }

    @Override
    public void setTitle(Translatable value) {
        this.setAttr(Case.Metadata.TITLE, value);
    }

    @Override
    public Translatable getTitle() {
        return this.getAttr(Case.Metadata.TITLE);
    }

    @Override
    public void setPriority(int value) {
        this.setAttr(Case.Metadata.PRIORITY, value);
    }

    @Override
    public int getPriority() {
        return this.getAttr(Case.Metadata.PRIORITY);
    }

    @Override
    public void setCategory(Category value) {
        this.setAttr(Case.Metadata.CATEGORY, value);
    }

    @Override
    public Category getCategory() {
        return this.getAttr(Case.Metadata.CATEGORY);
    }

    @Override
    public void setPermissions(@NotNull Permissions value) {
        this.setAttr(Case.Metadata.PERMISSIONS, value);
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.getAttr(Case.Metadata.PERMISSIONS);
    }

    @Override
    public void setMilestones(@NotNull Milestones value) {
        this.setAttr(Case.Metadata.MILESTONES, value);
    }

    @Override
    @NotNull
    public Milestones getMilestones() {
        return this.getAttr(Case.Metadata.MILESTONES);
    }

    @Override
    public void setEcmFolder(@Nullable EcmFolder value) {
        this.setAttr(Case.Metadata.ECM_FOLDER, value);
    }

    @Override
    public EcmFolder getEcmFolder() {
        return this.getAttr(Case.Metadata.ECM_FOLDER);
    }

    @Override
    public void addCaseData(CaseData value) {
        this.getAttr(Case.Metadata.CASE_DATA).add(value);
    }

    @Override
    public void removeCaseData(CaseData value) {
        this.getAttr(Case.Metadata.CASE_DATA).remove(value);
    }

    @Override
    public void clearCaseData() {
        this.getAttr(Case.Metadata.CASE_DATA).clear();
    }

    @Override
    public List<CaseData> getCaseData() {
        return Collections.unmodifiableList(this.getAttr(Case.Metadata.CASE_DATA));
    }

    @Override
    public void setEvents(@NotNull Events value) {
        this.setAttr(Case.Metadata.EVENTS, value);
    }

    @Override
    @NotNull
    public Events getEvents() {
        return this.getAttr(Case.Metadata.EVENTS);
    }

    @Override
    public void setOutcomes(@NotNull Outcomes value) {
        this.setAttr(Case.Metadata.OUTCOMES, value);
    }

    @Override
    @NotNull
    public Outcomes getOutcomes() {
        return this.getAttr(Case.Metadata.OUTCOMES);
    }

    @Override
    public void setPublishEvents(boolean value) {
        this.setAttr(Case.Metadata.PUBLISH_EVENTS, value);
    }

    @Override
    public boolean isPublishEvents() {
        return this.getAttr(Case.Metadata.PUBLISH_EVENTS);
    }

    @Override
    public void setStakeHolders(StakeHolders value) {
        this.setAttr(Case.Metadata.STAKE_HOLDERS, value);
    }

    @Override
    public StakeHolders getStakeHolders() {
        return this.getAttr(Case.Metadata.STAKE_HOLDERS);
    }

    @Override
    public void setResourceBundle(String value) {
        this.setAttr(Case.Metadata.RESOURCE_BUNDLE, value);
    }

    @Override
    public String getResourceBundle() {
        return this.getAttr(Case.Metadata.RESOURCE_BUNDLE);
    }

    @Override
    public void setPropertyBundles(PropertyBundles value) {
        this.setAttr(Case.Metadata.PROPERTY_BUNDLES, value);
    }

    @Override
    public PropertyBundles getPropertyBundles() {
        return this.getAttr(Case.Metadata.PROPERTY_BUNDLES);
    }

    @Override
    public void setNamespacePrefixes(NamespacePrefixes value) {
        this.setAttr(Case.Metadata.NAMESPACE_PREFIXES, value);
    }

    @Override
    public NamespacePrefixes getNamespacePrefixes() {
        return this.getAttr(Case.Metadata.NAMESPACE_PREFIXES);
    }
}

