/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.ca.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameterType;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TBpmnActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCaseActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCaseDataInput;
import oracle.bpm.casemgmt.model.ca.jaxb.TComponentInfo;
import oracle.bpm.casemgmt.model.ca.jaxb.TCustomActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCustomDefinition;
import oracle.bpm.casemgmt.model.ca.jaxb.TElementDataTypeEnum;
import oracle.bpm.casemgmt.model.ca.jaxb.TInputParameter;
import oracle.bpm.casemgmt.model.ca.jaxb.TInputs;
import oracle.bpm.casemgmt.model.ca.jaxb.TNMOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputParameter;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputs;
import oracle.bpm.casemgmt.model.ca.jaxb.TParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TPayloadInput;
import oracle.bpm.casemgmt.model.ca.jaxb.TPayloadOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TSaveData;
import oracle.bpm.casemgmt.model.ca.jaxb.TSaveDataAs;
import oracle.bpm.casemgmt.model.ca.jaxb.TWorkflowActivity;
import oracle.bpm.casemgmt.model.ca.persistence.CaseActivityTranslator;
import oracle.bpm.lang.Str;

class CaseActivityWriter {
    private CaseActivityWriter() {
    }

    public static oracle.bpm.casemgmt.model.ca.jaxb.CaseActivity translate(CaseActivity caseActivity) {
        TCaseActivity result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTCaseActivity();
        result.setTargetNamespace(caseActivity.getTargetNamespace());
        result.setName(caseActivity.getName());
        result.setActivityDefinitionId(caseActivity.getId());
        Activity activity = caseActivity.getActivity();
        if (activity != null) {
            Activity.Type type = activity.getType();
            result.setActivityType(CaseActivityWriter.translate(type));
            switch (type) {
                case BPMN: {
                    result.setBpmnActivity(CaseActivityWriter.translate(activity.toBpmn()));
                    break;
                }
                case HUMANTASK: {
                    result.setWorkflowActivity(CaseActivityWriter.translate(activity.toHumanTask()));
                    break;
                }
                case CUSTOM: {
                    result.setCustomActivity(CaseActivityWriter.translate(activity.toCustom()));
                }
            }
        }
        result.setRepeatable(caseActivity.isRepeatable());
        result.setRequired(caseActivity.isRequired());
        result.setManual(caseActivity.isManual());
        result.setIsGlobal(caseActivity.isGlobal());
        result.setIsConditional(caseActivity.isConditional());
        String permission = caseActivity.getPermission();
        if (!Str.isEmpty((String)permission)) {
            result.setPermissionTag(permission);
        }
        return CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createCaseActivity(result);
    }

    private static TActivity translate(Activity.Type type) {
        TActivity result;
        switch (type) {
            case BPMN: {
                result = TActivity.BPMN;
                break;
            }
            case HUMANTASK: {
                result = TActivity.HWF;
                break;
            }
            case CUSTOM: {
                result = TActivity.CUSTOM;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static TBpmnActivity translate(Activity.Bpmn activity) {
        TBpmnActivity result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTBpmnActivity();
        result.setParameters(CaseActivityWriter.translateParameters(activity));
        result.setComponentInfo(CaseActivityWriter.translate(activity.getComponentInfo()));
        return result;
    }

    private static TWorkflowActivity translate(Activity.Humantask activity) {
        TWorkflowActivity result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTWorkflowActivity();
        result.setParameters(CaseActivityWriter.translateParameters(activity));
        result.setComponentInfo(CaseActivityWriter.translate(activity.getComponentInfo()));
        return result;
    }

    private static TParameters translateParameters(Activity activity) {
        boolean existOutput;
        TParameters result = null;
        boolean existInput = !activity.getInputParameters().isEmpty();
        boolean bl = existOutput = !activity.getOutputParameters().isEmpty();
        if (existInput || existOutput) {
            result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTParameters();
            if (existInput) {
                TInputs tInputs = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTInputs();
                tInputs.getParameter().addAll(CaseActivityWriter.translate(activity.getInputParameters()));
                result.setInputs(tInputs);
            }
            if (existOutput) {
                TOutputs tOutputs = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTOutputs();
                tOutputs.getOutput().addAll(CaseActivityWriter.translate(activity.getOutputParameters()));
                result.setOutputs(tOutputs);
            }
        }
        return result;
    }

    private static Collection<TOutput> translate(OutputParameters outputParameters) {
        ArrayList<TOutput> result = new ArrayList<TOutput>();
        for (Output output : outputParameters) {
            TOutput tOutput = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTOutput();
            tOutput.setEndpoint(output.getEndPoint());
            tOutput.setOperationName(output.getOperationName());
            tOutput.setParameters(CaseActivityWriter.translate(output));
            result.add(tOutput);
        }
        return result;
    }

    private static Collection<TInputParameter> translate(InputParameters inputParameters) {
        ArrayList<TInputParameter> result = new ArrayList<TInputParameter>();
        for (InputParameter parameter : inputParameters) {
            result.add(CaseActivityWriter.translate(parameter));
        }
        return result;
    }

    private static TInputParameter translate(InputParameter input) {
        TInputParameter result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTInputParameter();
        InputParameterType type = input.getType();
        if (type.isCaseData()) {
            TCaseDataInput tCaseDataInput = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTCaseDataInput();
            InputParameter.CaseData caseData = input.toCaseData();
            tCaseDataInput.setActivityParamName(caseData.getParamName());
            tCaseDataInput.setElementName(caseData.getElementName());
            tCaseDataInput.setCaseDataName(caseData.getDataName());
            result.setCaseDataInput(tCaseDataInput);
        } else if (type.isPayload()) {
            TPayloadInput tPayloadInput = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTPayloadInput();
            InputParameter.Payload payload = input.toPayload();
            tPayloadInput.setActivityParamName(payload.getParamName());
            tPayloadInput.setElementName(payload.getElementName());
            tPayloadInput.setElementType(payload.getElementType());
            tPayloadInput.setElementSchemaLocation(payload.getElementSchemaLocation());
            if (payload.getElementDataType() != null) {
                tPayloadInput.setElementDataType(CaseActivityWriter.translate(payload.getElementDataType()));
            }
            if (payload.isStoreData()) {
                TSaveData tSaveData = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTSaveData();
                tSaveData.setSaveDataAs(TSaveDataAs.CASE_DATA);
                tSaveData.setDataName(payload.getDataName());
                tPayloadInput.setSaveData(tSaveData);
            }
            result.setPayloadInput(tPayloadInput);
        }
        return result;
    }

    private static TElementDataTypeEnum translate(DataType elementDataTypeEnum) {
        TElementDataTypeEnum result = null;
        switch (elementDataTypeEnum) {
            case SIMPLE_TYPE: {
                result = TElementDataTypeEnum.SIMPLE_TYPE;
                break;
            }
            case COMPLEX_TYPE: {
                result = TElementDataTypeEnum.COMPLEX_TYPE;
                break;
            }
            case ELEMENT: {
                result = TElementDataTypeEnum.ELEMENT;
            }
        }
        return result;
    }

    private static TOutputParameters translate(List<OutputParameter> parameters) {
        TOutputParameters result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTOutputParameters();
        for (OutputParameter parameter : parameters) {
            result.getParameter().add(CaseActivityWriter.translate(parameter));
        }
        return result;
    }

    private static TOutputParameter translate(OutputParameter outputParameter) {
        TOutputParameter result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTOutputParameter();
        OutputParameterType type = outputParameter.getType();
        if (type.isNormalizedMessage()) {
            TNMOutput tNMOutput = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTNMOutput();
            OutputParameter.NormalizedMessage nm = outputParameter.asNormalizedMessage();
            tNMOutput.setActivityParamName(nm.getParamName());
            tNMOutput.setElementName(nm.getElementName());
            if (nm.isStoreData()) {
                TSaveData tSaveData = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTSaveData();
                tSaveData.setSaveDataAs(TSaveDataAs.CASE_DATA);
                tSaveData.setDataName(outputParameter.getDataName());
                tNMOutput.setSaveData(tSaveData);
            }
            result.setNmOutput(tNMOutput);
        } else if (type.isPayload()) {
            TPayloadOutput tPayloadOutput = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTPayloadOutput();
            tPayloadOutput.setActivityParamName(outputParameter.getParamName());
            if (outputParameter.isStoreData()) {
                TSaveData tSaveData = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTSaveData();
                tSaveData.setSaveDataAs(TSaveDataAs.CASE_DATA);
                tSaveData.setDataName(outputParameter.getDataName());
                tPayloadOutput.setSaveData(tSaveData);
            }
            result.setPayloadOutput(tPayloadOutput);
        }
        return result;
    }

    private static TComponentInfo translate(ComponentInfo componentInfo) {
        TComponentInfo result = null;
        if (componentInfo != null) {
            result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTComponentInfo();
            result.setReferenceName(componentInfo.getReference());
            result.setNamespace(componentInfo.getNamespace());
            result.setOperationName(componentInfo.getOperation());
            result.setIsSynchronous(componentInfo.isSynchronous());
        }
        return result;
    }

    private static TCustomActivity translate(Activity.Custom activity) {
        TCustomActivity result = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTCustomActivity();
        TCustomDefinition tCustomDefinition = CaseActivityTranslator.CASE_ACTIVITY_FACTORY.createTCustomDefinition();
        tCustomDefinition.setClassName(activity.getClassName());
        result.setDefinition(tCustomDefinition);
        result.setParameters(CaseActivityWriter.translateParameters(activity));
        return result;
    }
}

