/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.ca.persistence;

import java.util.List;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TBpmnActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCaseActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCaseDataInput;
import oracle.bpm.casemgmt.model.ca.jaxb.TComponentInfo;
import oracle.bpm.casemgmt.model.ca.jaxb.TCustomActivity;
import oracle.bpm.casemgmt.model.ca.jaxb.TCustomDefinition;
import oracle.bpm.casemgmt.model.ca.jaxb.TElementDataTypeEnum;
import oracle.bpm.casemgmt.model.ca.jaxb.TInputParameter;
import oracle.bpm.casemgmt.model.ca.jaxb.TInputs;
import oracle.bpm.casemgmt.model.ca.jaxb.TNMOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputParameter;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TOutputs;
import oracle.bpm.casemgmt.model.ca.jaxb.TParameters;
import oracle.bpm.casemgmt.model.ca.jaxb.TPayloadInput;
import oracle.bpm.casemgmt.model.ca.jaxb.TPayloadOutput;
import oracle.bpm.casemgmt.model.ca.jaxb.TSaveData;
import oracle.bpm.casemgmt.model.ca.jaxb.TSaveDataAs;
import oracle.bpm.casemgmt.model.ca.jaxb.TWorkflowActivity;

class CaseActivityLoader {
    private CaseActivityLoader() {
    }

    public static CaseActivity translate(oracle.bpm.casemgmt.model.ca.jaxb.CaseActivity caseActivity) {
        CaseActivity result = CaseActivityFactory.createCaseActivity();
        TCaseActivity tCaseActivity = (TCaseActivity)caseActivity.getValue();
        result.setTargetNamespace(tCaseActivity.getTargetNamespace());
        result.setName(tCaseActivity.getName());
        result.setId(tCaseActivity.getActivityDefinitionId());
        result.setRepeatable(tCaseActivity.isRepeatable());
        result.setRequired(tCaseActivity.isRequired());
        result.setManual(tCaseActivity.isManual());
        result.setGlobal(tCaseActivity.isIsGlobal());
        result.setConditional(tCaseActivity.isIsConditional());
        if (tCaseActivity.isSetPermissionTag()) {
            result.setPermission(tCaseActivity.getPermissionTag());
        }
        result.setActivity(CaseActivityLoader.translateActivity(tCaseActivity));
        return result;
    }

    private static Activity translateActivity(TCaseActivity tCaseActivity) {
        Activity result = null;
        TActivity tActivity = tCaseActivity.getActivityType();
        if (tActivity != null) {
            switch (tActivity) {
                case BPMN: {
                    result = CaseActivityLoader.translate(tCaseActivity.getBpmnActivity());
                    break;
                }
                case HWF: {
                    result = CaseActivityLoader.translate(tCaseActivity.getWorkflowActivity());
                    break;
                }
                case CUSTOM: {
                    result = CaseActivityLoader.translate(tCaseActivity.getCustomActivity());
                }
            }
        }
        return result;
    }

    private static Activity.Bpmn translate(TBpmnActivity tBpmnActivity) {
        Activity.Bpmn result = CaseActivityFactory.createBpmnActivity();
        CaseActivityLoader.apply(result, tBpmnActivity.getParameters());
        result.setComponentInfo(CaseActivityLoader.translate(tBpmnActivity.getComponentInfo()));
        return result;
    }

    private static Activity.Humantask translate(TWorkflowActivity tWorkflowActivity) {
        Activity.Humantask result = CaseActivityFactory.createHumantaskActivity();
        CaseActivityLoader.apply(result, tWorkflowActivity.getParameters());
        result.setComponentInfo(CaseActivityLoader.translate(tWorkflowActivity.getComponentInfo()));
        return result;
    }

    private static void apply(Activity activity, TParameters tParameters) {
        if (tParameters != null) {
            TOutputs tOutputs;
            TInputs tInputs = tParameters.getInputs();
            if (tInputs != null) {
                activity.setInputParameters(CaseActivityLoader.translate(tInputs));
            }
            if ((tOutputs = tParameters.getOutputs()) != null) {
                activity.setOutputParameters(CaseActivityLoader.translate(tOutputs));
            }
        }
    }

    private static Activity.Custom translate(TCustomActivity tCustomActivity) {
        Activity.Custom result = CaseActivityFactory.createCustomActivity();
        TCustomDefinition tCustomDefinition = tCustomActivity.getDefinition();
        if (tCustomDefinition != null) {
            result.setClassName(tCustomDefinition.getClassName());
        }
        CaseActivityLoader.apply(result, tCustomActivity.getParameters());
        return result;
    }

    private static InputParameters translate(TInputs tInputs) {
        List<TInputParameter> tInputParameters = tInputs.getParameter();
        InputParameters result = CaseActivityFactory.createInputParameters();
        for (TInputParameter tInputParameter : tInputParameters) {
            InputParameter parameter = CaseActivityLoader.translate(tInputParameter);
            if (parameter == null) continue;
            result.add(parameter);
        }
        return result;
    }

    private static OutputParameters translate(TOutputs tOutputs) {
        List<TOutput> tOutputList = tOutputs.getOutput();
        OutputParameters result = CaseActivityFactory.createOutputParameters();
        for (TOutput tOutput : tOutputList) {
            result.add(CaseActivityLoader.translate(tOutput));
        }
        return result;
    }

    private static Output translate(TOutput tOutput) {
        Output result = CaseActivityFactory.createOutput();
        result.setEndPoint(tOutput.getEndpoint());
        result.setOperationName(tOutput.getOperationName());
        TOutputParameters tOutputParameters = tOutput.getParameters();
        List<TOutputParameter> tOutputParameterList = tOutputParameters.getParameter();
        for (TOutputParameter tOutputParameter : tOutputParameterList) {
            result.add(CaseActivityLoader.translate(tOutputParameter));
        }
        return result;
    }

    private static OutputParameter translate(TOutputParameter tOutputParameter) {
        OutputParameter result = null;
        if (tOutputParameter.isSetPayloadOutput()) {
            result = CaseActivityLoader.translate(tOutputParameter.getPayloadOutput());
        } else if (tOutputParameter.isSetNmOutput()) {
            result = CaseActivityLoader.translate(tOutputParameter.getNmOutput());
        }
        return result;
    }

    private static InputParameter translate(TInputParameter tInputParameter) {
        InputParameter result = null;
        if (tInputParameter.isSetPayloadInput()) {
            result = CaseActivityLoader.translate(tInputParameter.getPayloadInput());
        } else if (tInputParameter.isSetCaseDataInput()) {
            result = CaseActivityLoader.translate(tInputParameter.getCaseDataInput());
        }
        return result;
    }

    private static InputParameter.CaseData translate(TCaseDataInput tCaseDataInput) {
        InputParameter.CaseData result = CaseActivityFactory.createCaseDataInputParameter();
        result.setParamName(tCaseDataInput.getActivityParamName());
        result.setElementName(tCaseDataInput.getElementName());
        result.setDataName(tCaseDataInput.getCaseDataName());
        return result;
    }

    private static InputParameter.Payload translate(TPayloadInput tPayloadInput) {
        TSaveData tSaveData;
        InputParameter.Payload result = CaseActivityFactory.createPayloadInputParameter();
        result.setParamName(tPayloadInput.getActivityParamName());
        result.setElementName(tPayloadInput.getElementName());
        result.setElementType(tPayloadInput.getElementType());
        result.setElementSchemaLocation(tPayloadInput.getElementSchemaLocation());
        if (tPayloadInput.getElementDataType() != null) {
            result.setElementDataType(CaseActivityLoader.translate(tPayloadInput.getElementDataType()));
        }
        if (tPayloadInput.isSetSaveData() && TSaveDataAs.CASE_DATA.equals((Object)(tSaveData = tPayloadInput.getSaveData()).getSaveDataAs())) {
            result.setStoreData(true);
            result.setDataName(tSaveData.getDataName());
        }
        return result;
    }

    private static DataType translate(TElementDataTypeEnum tElementDataTypeEnum) {
        DataType result = null;
        switch (tElementDataTypeEnum) {
            case SIMPLE_TYPE: {
                result = DataType.SIMPLE_TYPE;
                break;
            }
            case COMPLEX_TYPE: {
                result = DataType.COMPLEX_TYPE;
                break;
            }
            case ELEMENT: {
                result = DataType.ELEMENT;
            }
        }
        return result;
    }

    private static OutputParameter.NormalizedMessage translate(TNMOutput tNMOutput) {
        TSaveData tSaveData;
        OutputParameter.NormalizedMessage result = CaseActivityFactory.createNormalizedMessageOutputParameter();
        result.setParamName(tNMOutput.getActivityParamName());
        result.setElementName(tNMOutput.getElementName());
        if (tNMOutput.isSetSaveData() && TSaveDataAs.CASE_DATA.equals((Object)(tSaveData = tNMOutput.getSaveData()).getSaveDataAs())) {
            result.setStoreData(true);
            result.setDataName(tSaveData.getDataName());
        }
        return result;
    }

    private static OutputParameter translate(TPayloadOutput tPayloadOutput) {
        TSaveData tSaveData;
        OutputParameter result = CaseActivityFactory.createOutputParameter();
        result.setParamName(tPayloadOutput.getActivityParamName());
        if (tPayloadOutput.isSetSaveData() && TSaveDataAs.CASE_DATA.equals((Object)(tSaveData = tPayloadOutput.getSaveData()).getSaveDataAs())) {
            result.setStoreData(true);
            result.setDataName(tSaveData.getDataName());
        }
        return result;
    }

    private static ComponentInfo translate(TComponentInfo tComponentInfo) {
        ComponentInfo result = null;
        if (tComponentInfo != null) {
            result = CaseActivityFactory.createComponentInfo();
            result.setReference(tComponentInfo.getReferenceName());
            result.setNamespace(tComponentInfo.getNamespace());
            result.setOperation(tComponentInfo.getOperationName());
            if (tComponentInfo.isSetIsSynchronous()) {
                result.setSynchronous(tComponentInfo.isIsSynchronous());
            }
        }
        return result;
    }
}

