/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.ca.impl;

import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.common.model.impl.EntityImpl;
import org.jetbrains.annotations.NotNull;

public class ActivityImpl
extends EntityImpl
implements Activity,
Activity.Bpmn,
Activity.Humantask,
Activity.Custom {
    private static final long serialVersionUID = -5882002474870135884L;

    private ActivityImpl(Activity.Type type) {
        this.changeTo(type);
    }

    public static Activity.Bpmn createBpmn() {
        return new ActivityImpl(Activity.Type.BPMN);
    }

    public static Activity.Humantask createHumantask() {
        return new ActivityImpl(Activity.Type.HUMANTASK);
    }

    public static Activity.Custom createCustom() {
        return new ActivityImpl(Activity.Type.CUSTOM);
    }

    @Override
    public Activity.Type getType() {
        return this.getAttr(Activity.Metadata.TYPE);
    }

    @Override
    public Activity.Bpmn toBpmn() {
        if (!this.getType().isBpmn()) {
            this.changeTo(Activity.Type.BPMN);
        }
        return this;
    }

    @Override
    public Activity.Humantask toHumanTask() {
        if (!this.getType().isHumantask()) {
            this.changeTo(Activity.Type.HUMANTASK);
        }
        return this;
    }

    @Override
    public Activity.Custom toCustom() {
        if (!this.getType().isCustom()) {
            this.changeTo(Activity.Type.CUSTOM);
        }
        return this;
    }

    @Override
    public Activity.Component asComponent() {
        return this;
    }

    @Override
    public void setInputParameters(@NotNull InputParameters value) {
        this.setAttr(Activity.Component.Metadata.INPUT_PARAMETERS, value);
    }

    @Override
    @NotNull
    public InputParameters getInputParameters() {
        return this.getAttr(Activity.Component.Metadata.INPUT_PARAMETERS);
    }

    @Override
    public void setOutputParameters(@NotNull OutputParameters value) {
        this.setAttr(Activity.Component.Metadata.OUTPUT_PARAMETERS, value);
    }

    @Override
    @NotNull
    public OutputParameters getOutputParameters() {
        return this.getAttr(Activity.Component.Metadata.OUTPUT_PARAMETERS);
    }

    @Override
    public void setComponentInfo(ComponentInfo value) {
        this.setAttr(Activity.Component.Metadata.COMPONENT_INFO, value);
    }

    @Override
    public ComponentInfo getComponentInfo() {
        return this.getAttr(Activity.Component.Metadata.COMPONENT_INFO);
    }

    @Override
    public void setClassName(String value) {
        this.setAttr(Activity.Custom.Metadata.CLASS_NAME, value);
    }

    @Override
    public String getClassName() {
        return this.getAttr(Activity.Custom.Metadata.CLASS_NAME);
    }

    private void setType(Activity.Type type) {
        this.setAttr(Activity.Metadata.TYPE, type);
    }

    private void changeTo(Activity.Type type) {
        this.setInputParameters(CaseActivityFactory.createInputParameters());
        this.setOutputParameters(CaseActivityFactory.createOutputParameters());
        this.setComponentInfo(CaseActivityFactory.createComponentInfo());
        this.setClassName(null);
        this.setType(type);
    }
}

