/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.ca;

import java.util.Locale;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.common.model.MetadataFactory;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public interface Activity {
    public Type getType();

    public Bpmn toBpmn();

    public Humantask toHumanTask();

    public Custom toCustom();

    public Component asComponent();

    public void setInputParameters(@NotNull InputParameters var1);

    @NotNull
    public InputParameters getInputParameters();

    public void setOutputParameters(@NotNull OutputParameters var1);

    @NotNull
    public OutputParameters getOutputParameters();

    public static class Metadata {
        public static final Attr<Type> TYPE = MetadataFactory.valueAttr(Type.class);

        static {
            MetadataFactory.init(Metadata.class);
        }
    }

    public static interface Component
    extends Activity {
        public void setComponentInfo(ComponentInfo var1);

        public ComponentInfo getComponentInfo();

        public static class Metadata
        extends oracle.bpm.casemgmt.model.ca.Activity$Metadata {
            public static final Attr<InputParameters> INPUT_PARAMETERS = MetadataFactory.valueAttr(InputParameters.class);
            public static final Attr<OutputParameters> OUTPUT_PARAMETERS = MetadataFactory.valueAttr(OutputParameters.class);
            public static final Attr<ComponentInfo> COMPONENT_INFO = MetadataFactory.valueAttr(ComponentInfo.class);

            static {
                MetadataFactory.init(Metadata.class);
            }
        }
    }

    public static interface Humantask
    extends Component {

        public static class Metadata
        extends Component.Metadata {
            static {
                MetadataFactory.init(Metadata.class);
            }
        }
    }

    public static interface Custom
    extends Activity {
        public void setClassName(String var1);

        public String getClassName();

        public static class Metadata
        extends oracle.bpm.casemgmt.model.ca.Activity$Metadata {
            public static final Attr<String> CLASS_NAME = MetadataFactory.valueAttr(String.class);

            static {
                MetadataFactory.init(Metadata.class);
            }
        }
    }

    public static interface Bpmn
    extends Component {

        public static class Metadata
        extends Component.Metadata {
            static {
                MetadataFactory.init(Metadata.class);
            }
        }
    }

    public static enum Type implements I18nProvider
    {
        BPMN(CaseModelMsg.BPMN_PROCESS, "BPMN"),
        HUMANTASK(CaseModelMsg.HUMAN_TASK, "HWF"),
        CUSTOM(CaseModelMsg.CUSTOM, "CUSTOM");

        private Msg msg;
        private String compositeType;

        private Type(Msg msg, String compositeType) {
            this.msg = msg;
            this.compositeType = compositeType;
        }

        public boolean isBpmn() {
            return this.equals((Object)BPMN);
        }

        public boolean isHumantask() {
            return this.equals((Object)HUMANTASK);
        }

        public boolean isCustom() {
            return this.equals((Object)CUSTOM);
        }

        public boolean isComponent() {
            return this.isBpmn() || this.isHumantask();
        }

        public Msg getMsg() {
            return this.msg;
        }

        public String getString() {
            return this.msg.getString();
        }

        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }

        public String getCompositeType() {
            return this.compositeType;
        }
    }
}

