/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.group;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.fusion.designer.palette.group.AbstractPaletteGroup;
import oracle.bpm.fusion.designer.palette.item.DesignerPaletteItemFactory;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class GatewaysPaletteGroup
extends AbstractPaletteGroup {
    private GatewaysPaletteGroup(String groupType) {
        super(DesignerMsg.GATEWAYS, DesignerMsg.GATEWAYS, groupType);
    }

    public static GatewaysPaletteGroup create(String groupType) {
        return new GatewaysPaletteGroup(groupType);
    }

    @Override
    protected void addSections() {
        DefaultPaletteSection section = new DefaultPaletteSection();
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        if (this.isFull()) {
            for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultGateways()) {
                section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
        } else {
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.EXCLUSIVE_GATEWAY, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.PARALLEL_GATEWAY, theme));
        }
        this.addSection((PaletteSection)section);
    }
}

