/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.group;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.fusion.designer.palette.group.AbstractPaletteGroup;
import oracle.bpm.fusion.designer.palette.item.DesignerPaletteItemFactory;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class EventPaletteGroup
extends AbstractPaletteGroup {
    private EventPaletteGroup(String groupType) {
        super(DesignerMsg.EVENTS, DesignerMsg.EVENTS, groupType);
    }

    public static EventPaletteGroup create(String groupType) {
        return new EventPaletteGroup(groupType);
    }

    @Override
    protected void addSections() {
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        if (this.isFull()) {
            DefaultPaletteSection section = new DefaultPaletteSection(ProjectModelMsg.CATCH_EVENTS.getString(), ProjectModelMsg.CATCH_EVENTS.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultCatchEvents()) {
                section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)section);
            section = new DefaultPaletteSection(ProjectModelMsg.THROW_EVENTS.getString(), ProjectModelMsg.THROW_EVENTS.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultThrowEvents()) {
                section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)section);
            section = new DefaultPaletteSection(ProjectModelMsg.START_EVENTS.getString(), ProjectModelMsg.START_EVENTS.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getStartEvents()) {
                section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)section);
            section = new DefaultPaletteSection(ProjectModelMsg.END_EVENTS.getString(), ProjectModelMsg.END_EVENTS.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getEndEvents()) {
                section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)section);
        } else {
            DefaultPaletteSection section = new DefaultPaletteSection();
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.START_EVENT_MESSAGE, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.START_EVENT_TIMER, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.START_EVENT, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.END_EVENT_MESSAGE, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.END_EVENT, theme));
            this.addSection((PaletteSection)section);
        }
    }
}

