/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.designer.palette.group;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.fusion.designer.palette.group.AbstractPaletteGroup;
import oracle.bpm.fusion.designer.palette.item.DesignerPaletteItemFactory;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class ActivitiesPaletteGroup
extends AbstractPaletteGroup {
    private ActivitiesPaletteGroup(String groupType) {
        super(DesignerMsg.ACTIVITIES, DesignerMsg.ACTIVITIES, groupType);
    }

    public static ActivitiesPaletteGroup create(String groupType) {
        return new ActivitiesPaletteGroup(groupType);
    }

    @Override
    protected void addSections() {
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        if (this.isFull()) {
            DefaultPaletteSection defaultSection = new DefaultPaletteSection(DesignerMsg.DEFAULT_MSG.getString(), DesignerMsg.DEFAULT_MSG.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultActivities()) {
                defaultSection.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)defaultSection);
            DefaultPaletteSection interactiveSection = new DefaultPaletteSection(ProjectModelMsg.INTERACTIVE.getString(), ProjectModelMsg.INTERACTIVE.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getUserTasksActivities()) {
                interactiveSection.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)interactiveSection);
            DefaultPaletteSection notificationSection = new DefaultPaletteSection(DesignerMsg.NOTIFICATION.getString(), DesignerMsg.NOTIFICATION.getString());
            for (FlowFigureType type : FlowFigureTypeProvider.getNotificationActivities()) {
                notificationSection.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(type, theme));
            }
            this.addSection((PaletteSection)notificationSection);
        } else {
            DefaultPaletteSection section = new DefaultPaletteSection();
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.ABSTRACT_ACTIVITY, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.USER_TASK, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.SERVICE_TASK, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.CALL_ACTIVITY, theme));
            section.addItem((PaletteItem)DesignerPaletteItemFactory.createItemForFlowFigureType(FlowFigureType.SUBPROCESS, theme));
            this.addSection((PaletteSection)section);
        }
    }
}

