/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.GradientPattern;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NonScrollTextArea;

public class WizardTitlePanel
extends Panel {
    private HeaderDescription descriptionLabel;
    private HeaderLabel headerLabel;
    private Color left = Color.valueOf(254, 254, 254);
    private Color right = Color.valueOf(206, 223, 230);

    public WizardTitlePanel(UiContainer parent, Image icon) {
        this(parent, icon, true);
    }

    public WizardTitlePanel(UiContainer parent, Image icon, boolean leaveMargin) {
        super(parent);
        this.setOpaque(false);
        FormLayout form = new FormLayout("10dlu,pref:grow,2dlu:grow,pref,10dlu", "2dlu,pref,2dlu,pref:grow,2dlu");
        this.setLayout(form);
        this.headerLabel = new HeaderLabel(this);
        HeaderLabel iconLabel = new HeaderLabel(this);
        if (icon != null) {
            iconLabel.setIcon(icon);
        }
        this.descriptionLabel = new HeaderDescription(this, leaveMargin);
        CellConstraints cc = form.createCellConstraints();
        this.add(this.headerLabel, cc.xy(2, 2));
        this.add(this.descriptionLabel, cc.xy(2, 4));
        this.add(iconLabel, cc.xywh(4, 2, 1, 3));
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        g.setPattern(new GradientPattern(0, 0, this.left, width, 0, this.right));
        g.fillRect(0, 0, width, this.getHeight());
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return Dimension.valueOf(200, 100);
    }

    public void setDescription(Msg msg) {
        this.descriptionLabel.setMsg(msg);
    }

    public void setDescription(String msg) {
        this.setDescription(UIMsg.TO_MSG(msg));
    }

    public void setTitle(Msg msg) {
        this.headerLabel.setText(msg);
    }

    public void setTitle(String msg) {
        this.headerLabel.setText(msg);
    }

    private class HeaderLabel
    extends Label {
        public HeaderLabel(UiContainer parent) {
            super(parent);
            this.setHorizontalTextPosition(10);
            this.setWithColon(false);
            this.setOpaque(false);
            Font font = this.getFont();
            this.setFont(font.bold().scale(1.3f));
            this.setVerticalAlignment(0);
        }
    }

    private class HeaderDescription
    extends NonScrollTextArea {
        public HeaderDescription(UiContainer parent, boolean leaveMargin) {
            super(parent);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, leaveMargin ? 15 : 0, 0, leaveMargin ? 30 : 10));
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setForeground(Color.BLACK);
            this.setFont(this.getFont().scale(0.9f));
            this.setFocusable(false);
        }

        public void setMsg(Msg msg) {
            this.setText(msg.toString());
        }
    }
}

