/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.WizardLastStep;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardStepSimpleTransition;
import oracle.bpm.ui.wizards.model.WizardStepTransition;
import oracle.bpm.ui.wizards.model.WizardSupport;
import oracle.bpm.ui.wizards.model.WizardTask;

public abstract class Wizard {
    protected Map<String, Object> properties_d;
    protected WizardSupport support;
    private Image banner;
    private boolean cancelled;
    private WizardStep firstStep;
    private Image icon;
    private Msg msg;
    private LinkedList<WizardStep> steps = new LinkedList();
    private Object userObject;

    protected Wizard() {
    }

    public void addStepsFrom(Wizard sourceWizard) {
        this.addSteps(sourceWizard.getSteps());
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void updateTitle(WizardStep nextStep) {
    }

    public void build() {
        LinkedList<WizardStep> steps = this.getSteps();
        WizardStep initialStep = this.getInitialStep();
        if (initialStep != null) {
            this.setFirstStep(initialStep);
            steps.addFirst(this.getFirstStep());
        } else {
            this.setFirstStep(steps.get(0));
        }
        WizardStep summaryStep = this.getSummaryStep();
        if (summaryStep != null) {
            steps.addLast(summaryStep);
        }
        this.checkStepTransitions();
    }

    public boolean containsProperty(String propertyName) {
        return this.getProperty(propertyName) != null;
    }

    public final Image getBanner() {
        return this.banner;
    }

    public WizardStep getFirstStep() {
        return this.firstStep;
    }

    public WizardStep getLastStep() {
        return this.steps.getLast();
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Dimension getProperSize() {
        return Dimension.valueOf(650, 550);
    }

    public Map<String, Object> getProperties() {
        if (this.properties_d == null) {
            this.properties_d = new HashMap<String, Object>();
        }
        return this.properties_d;
    }

    public Object getProperty(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    public Object getProperty(String propertyName, Object defaultValue) {
        Object result = this.getProperties().get(propertyName);
        return result != null ? result : defaultValue;
    }

    public LinkedList<WizardStep> getSteps() {
        return this.steps;
    }

    public WizardSupport getSupport() {
        if (this.support == null) {
            this.support = Ui.getUiFactory().createWizardSupport(this);
            this.support.initialize();
        }
        return this.support;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<WizardTask> processingTasks() {
        return null;
    }

    public void putProperty(String propertyName, Object propertyValue) {
        this.getProperties().put(propertyName, propertyValue);
    }

    public int run() {
        WizardSupport support = this.getSupport();
        int result = support.run();
        support.dispose();
        return result;
    }

    public final void setBanner(Image banner) {
        this.banner = banner;
    }

    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public final void setMsg(Msg msg) {
        this.msg = msg;
    }

    public void setProperties(Map<String, Object> aMap) {
        this.properties_d = aMap;
    }

    public void setProperty(String key, Object value) {
        if (this.properties_d != null) {
            this.properties_d.put(key, value);
        }
    }

    public void setUserObject(Object o) {
        this.userObject = o;
    }

    public boolean isLastStep(WizardStep step) {
        LinkedList<WizardStep> steps = this.getSteps();
        return steps.indexOf(step) == steps.size() - 1 || step instanceof WizardLastStep;
    }

    public boolean isFirstStep(WizardStep step) {
        return this.getSteps().indexOf(step) == 0;
    }

    public boolean showCancelSummaryPage() {
        return false;
    }

    public void checkStepTransitions() {
        LinkedList<WizardStep> steps = this.getSteps();
        for (int i = 0; i < steps.size() - 1; ++i) {
            WizardStepTransition stepTransition;
            WizardStep each = (WizardStep)steps.get(i);
            boolean lastStep = each instanceof WizardLastStep;
            each.setWizard(this);
            each.setNextStep(null);
            if (lastStep || (stepTransition = each.getStepTransition()) != null && !(stepTransition instanceof WizardStepSimpleTransition)) continue;
            WizardStep next = (WizardStep)steps.get(i + 1);
            each.setStepTransition(new WizardStepSimpleTransition(next));
        }
        if (!steps.isEmpty()) {
            WizardStep lastStep = this.getLastStep();
            lastStep.setStepTransition(new WizardStepSimpleTransition(null));
        }
    }

    public boolean doFinish() {
        return true;
    }

    public Image getIcon() {
        return this.icon == null ? Image.create(UIMsg.WIZARD_ICON) : this.icon;
    }

    protected abstract WizardStep getInitialStep();

    protected WizardStep getSummaryStep() {
        return null;
    }

    protected void initialize() {
    }

    private void addSteps(List<WizardStep> sourceSteps) {
        this.getSteps().addAll(sourceSteps);
        this.checkStepTransitions();
    }

    private void setFirstStep(WizardStep wizardStep) {
        this.firstStep = wizardStep;
    }
}

