/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tips;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.tips.TipOfTheDayDialog;
import oracle.bpm.util.FuegoDirectories;

public class TipOfTheDayFactory {
    private static String FUEGO_TIPS = "tips";
    private static String HELP = "help";
    private static final String DEF_LANGUAGE = Locale.ENGLISH.getLanguage();

    public static void showTipsDialog(UiWindow frame, boolean showTipsOnStartUp) {
        TipOfTheDayFactory.showTipsDialog(frame, null, showTipsOnStartUp);
    }

    public static void showTipsDialog(UiWindow frame, Locale loc, boolean showTipsOnStartUp) {
        try {
            File baseDir = TipOfTheDayFactory.getTipsDirectoryFile(loc);
            TipOfTheDayDialog d = TipOfTheDayDialog.createTipsDialog(frame, baseDir, showTipsOnStartUp);
            d.setVisible(true);
        }
        catch (FileNotFoundException e) {
            Log.logWarning(e);
        }
    }

    public static void showTipsDialog(Dialog dialog, Locale loc, boolean showTipsOnStartUp) {
        try {
            File baseDir = TipOfTheDayFactory.getTipsDirectoryFile(loc);
            TipOfTheDayDialog d = TipOfTheDayDialog.createTipsDialog(dialog, baseDir, showTipsOnStartUp);
            d.setVisible(true);
        }
        catch (FileNotFoundException e) {
            Log.logWarning(e);
        }
    }

    private static String getLanguageLocale(Locale l) {
        String language = "";
        language = l == null ? Locale.getDefault().getLanguage().toLowerCase() : l.getLanguage().toLowerCase(l);
        return language;
    }

    private static String getLanguageTipsDir(Locale l) {
        String language = TipOfTheDayFactory.getLanguageLocale(l);
        StringBuffer buff = new StringBuffer();
        buff.append(TipOfTheDayFactory.getTipsDir());
        buff.append(File.separatorChar);
        buff.append(FUEGO_TIPS);
        buff.append('_');
        buff.append(language);
        return buff.toString();
    }

    private static String getTipsDir() {
        StringBuffer buff = new StringBuffer();
        buff.append(FuegoDirectories.installation());
        buff.append(File.separatorChar);
        buff.append(HELP);
        buff.append(File.separatorChar);
        buff.append(FUEGO_TIPS);
        return buff.toString();
    }

    private static File getTipsDirectoryFile(Locale loc) throws FileNotFoundException {
        String path = TipOfTheDayFactory.getLanguageTipsDir(loc);
        File dir = new File(path);
        if (dir.exists() && new File(dir, "tips.xml").exists()) {
            return dir;
        }
        if (!loc.getLanguage().equals(DEF_LANGUAGE)) {
            return TipOfTheDayFactory.getTipsDirectoryFile(Locale.ENGLISH);
        }
        throw new FileNotFoundException(path);
    }
}

