/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import javax.swing.InputVerifier;
import javax.swing.text.Document;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiError;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.TextFieldPeer;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.text.TextComponent;

public class TextField
extends TextComponent {
    protected Class clazz;
    protected boolean showSpinner = true;
    private InputValidator validator;
    private static final int DEFAULT_SIZE = 12;

    public TextField(UiContainer parent) {
        this(parent, 12);
    }

    public TextField(UiContainer parent, int columns) {
        this(parent, null, columns, true);
    }

    public TextField(UiContainer parent, String text) {
        this(parent, text, 12);
    }

    public TextField(UiContainer parent, String text, int columns) {
        this(parent, text, columns, true);
    }

    public TextField(UiContainer parent, String text, int columns, boolean showSpinner) {
        super(parent);
        this.showSpinner = showSpinner;
        if (!(parent instanceof Table)) {
            UiUtilities.addToEditableContainer(this, parent);
        }
        this.setText(text);
        this.setColumns(columns);
    }

    protected TextField(Peer peer) {
        super(peer);
    }

    protected TextField(UiContainer parent, boolean showSpinner) {
        super(parent);
        this.showSpinner = showSpinner;
        if (!(parent instanceof Table)) {
            UiUtilities.addToEditableContainer(this, parent);
        }
    }

    protected TextField(UiContainer parent, boolean showSpinner, Class clazz) {
        super(parent);
        this.showSpinner = showSpinner;
        this.clazz = clazz;
        if (!(parent instanceof Table)) {
            UiUtilities.addToEditableContainer(this, parent);
        }
    }

    public void validateInput() throws InputValidationException {
        if (this.validator != null) {
            this.validator.validate(this.getText());
        }
    }

    public void setColumns(int columns) {
        this.getTextFieldPeer().setColumns(columns);
    }

    public int getColumns() {
        return this.getTextFieldPeer().getColumns();
    }

    public void setDocument(Document document) {
        this.getTextFieldPeer().setDocument(document);
    }

    public Document getDocument() {
        return this.getTextFieldPeer().getDocument();
    }

    public void setError(UiError error) {
        this.getTextFieldPeer().setError(error);
    }

    public void clearError() {
        this.setError(null);
    }

    public void setHorizontalAlignment(int align) {
        this.getTextFieldPeer().setHorizontalAlignment(align);
    }

    public int getHorizontalAlignment() {
        return this.getTextFieldPeer().getHorizontalAlignment();
    }

    public void setInputVerifier(InputVerifier verifier) {
        this.getTextFieldPeer().setInputVerifier(verifier);
    }

    public InputVerifier getInputVerifier() {
        return this.getTextFieldPeer().getInputVerifier();
    }

    public void setLength(int length) {
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Deprecated
    public void addActionListener(ActionListener listener) {
    }

    @Deprecated
    public void postActionEvent() {
    }

    protected void setInputValidator(InputValidator inputValidator) {
        this.validator = inputValidator;
    }

    protected TextFieldPeer getTextFieldPeer() {
        return (TextFieldPeer)this.getPeer();
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createTextField(this.getParentPeer());
    }
}

