/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table.editors;

import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class BooleanComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private ComboBox<Boolean> editor;

    @Override
    public Object getCellEditorValue() {
        return this.getEditor().getSelectedItem();
    }

    @Override
    public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
        return this.createEditor(parent, value);
    }

    @Override
    public UiComponent createEditor(UiContainer parent, Object value) {
        this.editor = UiFactory.createYesNoComboBox(parent);
        this.editor.setOpaque(false);
        this.setValue(value);
        return this.editor;
    }

    private void setValue(Object value) {
        ComboBox<Boolean> editor = this.getEditor();
        if (editor != null) {
            boolean selected = false;
            if (value instanceof Boolean) {
                selected = (Boolean)value;
            } else if (value instanceof String) {
                selected = Boolean.valueOf((String)value);
            }
            editor.setSelectedItem(selected);
        }
    }

    private ComboBox<Boolean> getEditor() {
        return this.editor;
    }
}

